/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DefaultServerRedirectStrategy
implements ServerRedirectStrategy {
    private static final Log logger = LogFactory.getLog(DefaultServerRedirectStrategy.class);
    private HttpStatus httpStatus = HttpStatus.FOUND;
    private boolean contextRelative = true;

    @Override
    public Mono<Void> sendRedirect(ServerWebExchange exchange2, URI location) {
        Assert.notNull((Object)exchange2, "exchange cannot be null");
        Assert.notNull((Object)location, "location cannot be null");
        return Mono.fromRunnable(() -> {
            ServerHttpResponse response = exchange2.getResponse();
            response.setStatusCode(this.httpStatus);
            URI newLocation = this.createLocation(exchange2, location);
            logger.debug(LogMessage.format("Redirecting to '%s'", (Object)newLocation));
            response.getHeaders().setLocation(newLocation);
        });
    }

    private URI createLocation(ServerWebExchange exchange2, URI location) {
        if (!this.contextRelative) {
            return location;
        }
        String url = location.toASCIIString();
        if (url.startsWith("/")) {
            String context = exchange2.getRequest().getPath().contextPath().value();
            return URI.create(context + url);
        }
        return location;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        Assert.notNull((Object)httpStatus, "httpStatus cannot be null");
        this.httpStatus = httpStatus;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }
}

