/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp.bit;

import java.io.File;
import java.util.List;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.queue.aws.SQSTaskQueue;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.impl.CredentialsRepoLocator;
import org.duracloud.mill.ltp.LoopingTaskProducer;
import org.duracloud.mill.ltp.LoopingTaskProducerDriverSupport;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.ltp.bit.BitIntegrityMorsel;
import org.duracloud.mill.ltp.bit.LoopingBitIntegrityTaskProducer;
import org.duracloud.mill.ltp.bit.LoopingBitTaskProducerConfigurationManager;
import org.duracloud.mill.notification.SESNotificationManager;
import org.duracloud.mill.util.CommonCommandLineOptions;
import org.duracloud.mill.util.PropertyDefinition;
import org.duracloud.mill.util.PropertyDefinitionListBuilder;
import org.duracloud.mill.util.PropertyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDriver
extends LoopingTaskProducerDriverSupport {
    private static Logger log = LoggerFactory.getLogger(AppDriver.class);

    public AppDriver() {
        super(new CommonCommandLineOptions());
    }

    public static void main(String[] args) {
        new AppDriver().execute(args);
    }

    private void processExclusionListOption() {
        File list;
        String exclusionList = System.getProperty("looping.bit.exclusion-list-file");
        if (exclusionList != null && !(list = new File(exclusionList)).exists()) {
            throw new DuraCloudRuntimeException("exclusion list not found: " + list);
        }
    }

    private void processInclusionListOption() {
        File list;
        String inclusionList = System.getProperty("looping.bit.inclusion-list-file");
        if (inclusionList != null && !(list = new File(inclusionList)).exists()) {
            throw new DuraCloudRuntimeException("inclusionlist not found: " + list);
        }
    }

    @Override
    protected LoopingTaskProducer buildTaskProducer() {
        List<PropertyDefinition> defintions = new PropertyDefinitionListBuilder().addAws().addNotificationRecipients().addMcDb().addBitIntegrityQueue().addLoopingBitFrequency().addLoopingBitMaxQueueSize().addWorkDir().build();
        PropertyVerifier verifier = new PropertyVerifier(defintions);
        verifier.verify(System.getProperties());
        this.processExclusionListOption();
        this.processInclusionListOption();
        LoopingBitTaskProducerConfigurationManager config = new LoopingBitTaskProducerConfigurationManager();
        CredentialsRepo credentialsRepo = CredentialsRepoLocator.get();
        StorageProviderFactory storageProviderFactory = new StorageProviderFactory();
        SESNotificationManager notificationMananger = new SESNotificationManager(config.getNotificationRecipients());
        SQSTaskQueue taskQueue = new SQSTaskQueue(config.getBitIntegrityQueue());
        String stateFilePath = new File(config.getWorkDirectoryPath(), "bit-producer-state.json").getAbsolutePath();
        StateManager<BitIntegrityMorsel> stateManager = new StateManager<BitIntegrityMorsel>(stateFilePath, BitIntegrityMorsel.class);
        LoopingBitIntegrityTaskProducer producer = new LoopingBitIntegrityTaskProducer(credentialsRepo, storageProviderFactory, taskQueue, stateManager, this.getMaxQueueSize("looping.bit.max-task-queue-size"), this.getFrequency("looping.bit.frequency"), notificationMananger, config.getPathFilterManager(), config);
        return producer;
    }
}

