/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp.bit;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.bit.BitIntegrityCheckReportTask;
import org.duracloud.mill.bit.BitIntegrityCheckTask;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.credentials.AccountCredentials;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.CredentialsRepoException;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.ltp.Frequency;
import org.duracloud.mill.ltp.LoopingTaskProducer;
import org.duracloud.mill.ltp.PathFilterManager;
import org.duracloud.mill.ltp.RunStats;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.ltp.bit.BitIntegrityMorsel;
import org.duracloud.mill.ltp.bit.BitIntegrityRunStats;
import org.duracloud.mill.ltp.bit.LoopingBitTaskProducerConfigurationManager;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingBitIntegrityTaskProducer
extends LoopingTaskProducer<BitIntegrityMorsel> {
    private static Logger log = LoggerFactory.getLogger(LoopingBitIntegrityTaskProducer.class);
    private PathFilterManager exclusionManager;
    private int waitTimeInMsBeforeQueueSizeCheck = 10000;

    public LoopingBitIntegrityTaskProducer(CredentialsRepo credentialsRepo, StorageProviderFactory storageProviderFactory, TaskQueue taskQueue, StateManager<BitIntegrityMorsel> state, int maxTaskQueueSize, Frequency frequency, NotificationManager notificationManager, PathFilterManager exclusionManager, LoopingBitTaskProducerConfigurationManager config) {
        super(credentialsRepo, storageProviderFactory, taskQueue, state, maxTaskQueueSize, frequency, notificationManager, config);
        this.exclusionManager = exclusionManager;
    }

    @Override
    protected void loadMorselQueueFromSource(Queue<BitIntegrityMorsel> morselQueue) {
        try {
            for (String account : this.getAccountsList()) {
                String accountPath = "/" + account;
                if (this.exclusionManager.isExcluded(accountPath)) continue;
                AccountCredentials accountCreds = this.getCredentialsRepo().getAccountCredentials(account);
                for (StorageProviderCredentials cred : accountCreds.getProviderCredentials()) {
                    String storePath = accountPath + "/" + cred.getProviderId();
                    if (this.exclusionManager.isExcluded(storePath)) continue;
                    StorageProvider store = this.getStorageProvider(cred);
                    Iterator<String> spaces = store.getSpaces();
                    while (spaces.hasNext()) {
                        String spaceId = spaces.next();
                        String spacePath = storePath + "/" + spaceId;
                        if (this.exclusionManager.isExcluded(spacePath)) continue;
                        morselQueue.add(new BitIntegrityMorsel(account, cred.getProviderId(), cred.getProviderType().name(), spaceId));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new DuraCloudRuntimeException(e);
        }
    }

    private List<String> getAccountsList() throws CredentialsRepoException {
        return this.getCredentialsRepo().getAccounts();
    }

    @Override
    protected void nibble(Queue<BitIntegrityMorsel> queue) {
        BitIntegrityMorsel morsel = queue.peek();
        String storeId = morsel.getStoreId();
        StorageProvider store = this.getStorageProvider(morsel.getAccount(), storeId);
        int maxTaskQueueSize = this.getMaxTaskQueueSize();
        int taskQueueSize = this.getTaskQueue().size();
        while (taskQueueSize < maxTaskQueueSize) {
            if (taskQueueSize >= maxTaskQueueSize) {
                log.info("Task queue size ({}) has reached or exceeded max size ({}).", (Object)taskQueueSize, (Object)maxTaskQueueSize);
            } else {
                if (this.addTasks(morsel, store, 1000)) {
                    log.info("All bit integrity tasks that could be created were created for account={}, storeId={}, spaceId={}. getTaskQueue().size = {}", morsel.getAccount(), storeId, morsel.getSpaceId(), this.getTaskQueue().size());
                    log.info("{} completely nibbled.", (Object)morsel);
                    log.debug("delay before checking the queue size in ms: {}", (Object)this.waitTimeInMsBeforeQueueSizeCheck);
                    this.sleep(this.waitTimeInMsBeforeQueueSizeCheck);
                    long size = this.getTaskQueue().sizeIncludingInvisibleAndDelayed().intValue();
                    if (size == 0L) {
                        this.addReportTaskProcessorTask(queue.poll());
                        break;
                    }
                    log.info("{} (queue) is not empty: {} items remain to be processed before creating report generation task.", (Object)this.getTaskQueue().getName(), (Object)size);
                    break;
                }
                log.info("morsel nibbled down: {}", (Object)morsel);
            }
            taskQueueSize = this.getTaskQueue().size();
        }
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void addReportTaskProcessorTask(BitIntegrityMorsel morsel) {
        BitIntegrityCheckReportTask task = new BitIntegrityCheckReportTask();
        task.setAccount(morsel.getAccount());
        task.setStoreId(morsel.getStoreId());
        task.setSpaceId(morsel.getSpaceId());
        Task t = task.writeTask();
        this.getTaskQueue().put(t);
        log.info("added report task: {}", (Object)t);
    }

    private boolean addTasks(BitIntegrityMorsel morsel, StorageProvider store, int biteSize) {
        String account = morsel.getAccount();
        String storeId = morsel.getStoreId();
        String spaceId = morsel.getSpaceId();
        String marker = morsel.getMarker();
        List<String> contentIds = null;
        try {
            contentIds = store.getSpaceContentsChunked(spaceId, null, biteSize, marker);
            int added = this.addToTaskQueue(account, storeId, spaceId, contentIds);
            ((BitIntegrityRunStats)this.getStats(account)).add(added);
            if (added == 0) {
                return true;
            }
            marker = contentIds.get(contentIds.size() - 1);
            morsel.setMarker(marker);
            return false;
        }
        catch (NotFoundException ex) {
            log.info("space not found on storage provider: subdomain={}, spaceId={}, storeId={}", account, spaceId, storeId);
            return true;
        }
    }

    private int addToTaskQueue(String account, String storeId, String spaceId, List<String> contentIds) {
        HashSet<Task> tasks = new HashSet<Task>();
        int addedCount = 0;
        for (String contentId : contentIds) {
            BitIntegrityCheckTask bitIntegrityTask = new BitIntegrityCheckTask();
            bitIntegrityTask.setAccount(account);
            bitIntegrityTask.setContentId(contentId);
            bitIntegrityTask.setSpaceId(spaceId);
            bitIntegrityTask.setStoreId(storeId);
            Task task = bitIntegrityTask.writeTask();
            tasks.add(task);
            ++addedCount;
        }
        this.getTaskQueue().put(tasks);
        return addedCount;
    }

    @Override
    protected void logIncrementalStatsByAccount(String account, RunStats stats) {
        log.info("Session stats by account (incremental): account={} tasksAdded={}", (Object)account, (Object)((BitIntegrityRunStats)stats).getAdded());
    }

    @Override
    protected void logCumulativeSessionStats(Map<String, RunStats> runstats, RunStats cumulativeTotals) {
        log.info("session stats (global cumulative): domains={} tasksAdded={}", (Object)runstats.keySet().size(), (Object)((BitIntegrityRunStats)cumulativeTotals).getAdded());
    }

    @Override
    protected void logGlobalncrementalStats(RunStats incrementalTotals) {
        log.info("Session stats (global incremental): tasksAdded={}", (Object)((BitIntegrityRunStats)incrementalTotals).getAdded());
    }

    @Override
    protected RunStats createRunStats() {
        return new BitIntegrityRunStats();
    }

    public void setWaitTimeInMsBeforeQueueSizeCheck(int ms) {
        this.waitTimeInMsBeforeQueueSizeCheck = ms;
    }

    @Override
    protected String getLoopingProducerTypePrefix() {
        return "bit";
    }
}

