/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.QueryAnnotation;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class DefaultRepositoryInformation
implements RepositoryInformation {
    private static final TypeVariable<Class<Repository>>[] PARAMETERS = Repository.class.getTypeParameters();
    private static final String DOMAIN_TYPE_NAME = PARAMETERS[0].getName();
    private static final String ID_TYPE_NAME = PARAMETERS[1].getName();
    private final Map<Method, Method> methodCache = new ConcurrentHashMap<Method, Method>();
    private final RepositoryMetadata metadata;
    private final Class<?> repositoryBaseClass;
    private final Class<?> customImplementationClass;

    public DefaultRepositoryInformation(RepositoryMetadata metadata, Class<?> repositoryBaseClass, Class<?> customImplementationClass) {
        Assert.notNull(metadata);
        Assert.notNull(repositoryBaseClass);
        this.metadata = metadata;
        this.repositoryBaseClass = repositoryBaseClass;
        this.customImplementationClass = customImplementationClass;
    }

    @Override
    public Class<?> getDomainType() {
        return this.metadata.getDomainType();
    }

    @Override
    public Class<? extends Serializable> getIdType() {
        return this.metadata.getIdType();
    }

    @Override
    public Class<?> getRepositoryBaseClass() {
        return this.repositoryBaseClass;
    }

    @Override
    public Method getTargetClassMethod(Method method) {
        if (this.methodCache.containsKey(method)) {
            return this.methodCache.get(method);
        }
        Method result = this.getTargetClassMethod(method, this.customImplementationClass);
        if (!result.equals(method)) {
            this.methodCache.put(method, result);
            return result;
        }
        result = this.getTargetClassMethod(method, this.repositoryBaseClass);
        this.methodCache.put(method, result);
        return result;
    }

    private boolean isTargetClassMethod(Method method, Class<?> targetType) {
        Assert.notNull(method);
        if (targetType == null) {
            return false;
        }
        if (method.getDeclaringClass().isAssignableFrom(targetType)) {
            return true;
        }
        return !method.equals(this.getTargetClassMethod(method, targetType));
    }

    public Set<Method> getQueryMethods() {
        HashSet<Method> result = new HashSet<Method>();
        for (Method method : this.getRepositoryInterface().getMethods()) {
            if (!this.isQueryMethodCandidate(method = ClassUtils.getMostSpecificMethod(method, this.getRepositoryInterface()))) continue;
            result.add(method);
        }
        return Collections.unmodifiableSet(result);
    }

    private boolean isQueryMethodCandidate(Method method) {
        return !method.isBridge() && !ReflectionUtils.isDefaultMethod(method) && (this.isQueryAnnotationPresentOn(method) || !this.isCustomMethod(method) && !this.isBaseClassMethod(method));
    }

    private boolean isQueryAnnotationPresentOn(Method method) {
        return AnnotationUtils.findAnnotation(method, QueryAnnotation.class) != null;
    }

    @Override
    public boolean isCustomMethod(Method method) {
        return this.isTargetClassMethod(method, this.customImplementationClass);
    }

    @Override
    public boolean isQueryMethod(Method method) {
        return this.getQueryMethods().contains(method);
    }

    @Override
    public boolean isBaseClassMethod(Method method) {
        Assert.notNull(method, "Method must not be null!");
        return this.isTargetClassMethod(method, this.repositoryBaseClass);
    }

    Method getTargetClassMethod(Method method, Class<?> baseClass) {
        if (baseClass == null) {
            return method;
        }
        for (Method baseClassMethod : baseClass.getMethods()) {
            if (!method.getName().equals(baseClassMethod.getName()) || method.getParameterTypes().length != baseClassMethod.getParameterTypes().length || !this.parametersMatch(method, baseClassMethod)) continue;
            return baseClassMethod;
        }
        return method;
    }

    @Override
    public boolean hasCustomMethod() {
        Class<?> repositoryInterface = this.getRepositoryInterface();
        if (org.springframework.data.repository.util.ClassUtils.isGenericRepositoryInterface(repositoryInterface)) {
            return false;
        }
        for (Method method : repositoryInterface.getMethods()) {
            if (!this.isCustomMethod(method) || this.isBaseClassMethod(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.metadata.getRepositoryInterface();
    }

    @Override
    public Class<?> getReturnedDomainClass(Method method) {
        return this.metadata.getReturnedDomainClass(method);
    }

    @Override
    public CrudMethods getCrudMethods() {
        return this.metadata.getCrudMethods();
    }

    @Override
    public boolean isPagingRepository() {
        return this.metadata.isPagingRepository();
    }

    private boolean parametersMatch(Method method, Method baseClassMethod) {
        Type[] genericTypes = baseClassMethod.getGenericParameterTypes();
        Class<?>[] types = baseClassMethod.getParameterTypes();
        for (int i = 0; i < genericTypes.length; ++i) {
            Type type = genericTypes[i];
            MethodParameter parameter = new MethodParameter(method, i);
            Class<?> parameterType = GenericTypeResolver.resolveParameterType(parameter, this.metadata.getRepositoryInterface());
            if (!(type instanceof TypeVariable ? !this.matchesGenericType((TypeVariable)type, parameterType) : !types[i].equals(parameterType))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesGenericType(TypeVariable<?> variable, Class<?> parameterType) {
        boolean isNotIterable;
        Class<?> entityType = this.getDomainType();
        Class<? extends Serializable> idClass = this.getIdType();
        if (ID_TYPE_NAME.equals(variable.getName()) && parameterType.isAssignableFrom(idClass)) {
            return true;
        }
        Type boundType = variable.getBounds()[0];
        String referenceName = boundType instanceof TypeVariable ? boundType.toString() : variable.toString();
        boolean isDomainTypeVariableReference = DOMAIN_TYPE_NAME.equals(referenceName);
        boolean parameterMatchesEntityType = parameterType.isAssignableFrom(entityType);
        boolean bl = isNotIterable = !parameterType.equals(Iterable.class);
        return isDomainTypeVariableReference && parameterMatchesEntityType && isNotIterable;
    }
}

