/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.handlers.KeystoneErrorHandler;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.functions.PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.util.Suppliers2;

@ConfiguresHttpApi
public class KeystoneHttpApiModule
extends HttpApiModule<KeystoneApi> {
    @Override
    protected void configure() {
        this.bind(ImplicitOptionalConverter.class).to(PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet.class);
        super.configure();
    }

    @Provides
    @Singleton
    public Multimap<URI, URI> aliases() {
        return ImmutableMultimap.builder().build();
    }

    @Provides
    @Singleton
    public LoadingCache<String, Set<? extends Extension>> provideExtensionsByZone(final javax.inject.Provider<KeystoneApi> keystoneApi) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from(Suppliers.memoize(new Supplier<Set<? extends Extension>>(){

            @Override
            public Set<? extends Extension> get() {
                return ((KeystoneApi)keystoneApi.get()).getExtensionApi().list();
            }
        })));
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(KeystoneErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(KeystoneErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(KeystoneErrorHandler.class);
    }

    public static class KeystoneAdminURLModule
    extends AbstractModule {
        @Override
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromAccessForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
        }

        @Provides
        @Singleton
        @Identity
        protected Supplier<URI> provideStorageUrl(RegionIdToAdminURISupplier.Factory factory, @ApiVersion String version, @Provider Supplier<URI> providerURI) {
            Supplier<URI> identityServiceForVersion = Suppliers2.getLastValueInMap(factory.createForApiTypeAndVersion("identity", version));
            Supplier<URI> whenIdentityServiceIsntListedFallbackToProviderURI = Suppliers2.onThrowable(identityServiceForVersion, NoSuchElementException.class, providerURI);
            Supplier<URI> whenIdentityServiceHasNoAdminURLFallbackToProviderURI = Suppliers2.or(whenIdentityServiceIsntListedFallbackToProviderURI, providerURI);
            return whenIdentityServiceHasNoAdminURLFallbackToProviderURI;
        }
    }
}

