/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.jpa.util.BeanDefinitionUtils;

public class EntityManagerBeanDefinitionRegistrarPostProcessor
implements BeanFactoryPostProcessor {
    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (BeanDefinitionUtils.EntityManagerFactoryBeanDefinition definitions : BeanDefinitionUtils.getEntityManagerFactoryBeanDefinitions(beanFactory)) {
            if (!(definitions.beanFactory instanceof BeanDefinitionRegistry)) continue;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition("org.springframework.orm.jpa.SharedEntityManagerCreator");
            builder.setFactoryMethod("createSharedEntityManager");
            builder.addConstructorArgReference(definitions.beanName);
            AbstractBeanDefinition emBeanDefinition = builder.getRawBeanDefinition();
            emBeanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)definitions.beanName));
            emBeanDefinition.setScope(definitions.beanDefinition.getScope());
            emBeanDefinition.setSource(definitions.beanDefinition.getSource());
            BeanDefinitionReaderUtils.registerWithGeneratedName(emBeanDefinition, (BeanDefinitionRegistry)((Object)definitions.beanFactory));
        }
    }
}

