/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp.bit;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.mill.bit.BitIntegrityCheckReportTask;
import org.duracloud.mill.bit.BitIntegrityCheckTask;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.credentials.AccountCredentials;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.CredentialsRepoException;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.db.model.BitIntegrityReport;
import org.duracloud.mill.db.repo.JpaBitIntegrityReportRepo;
import org.duracloud.mill.ltp.Frequency;
import org.duracloud.mill.ltp.LoopingTaskProducer;
import org.duracloud.mill.ltp.PathFilterManager;
import org.duracloud.mill.ltp.RunStats;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.ltp.bit.BitIntegrityMorsel;
import org.duracloud.mill.ltp.bit.BitIntegrityRunStats;
import org.duracloud.mill.ltp.bit.LoopingBitTaskProducerConfigurationManager;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.reportdata.bitintegrity.BitIntegrityReportResult;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingBitIntegrityTaskProducer
extends LoopingTaskProducer<BitIntegrityMorsel> {
    private static Logger log = LoggerFactory.getLogger(LoopingBitIntegrityTaskProducer.class);
    private PathFilterManager exclusionManager;
    private int waitTimeInMsBeforeQueueSizeCheck = 10000;
    private TaskQueue bitReportTaskQueue;
    private JpaBitIntegrityReportRepo bitReportRepo;
    private int waitBetweenRetriesMs = 5000;

    public LoopingBitIntegrityTaskProducer(CredentialsRepo credentialsRepo, JpaBitIntegrityReportRepo bitReportRepo, StorageProviderFactory storageProviderFactory, TaskQueue bitTaskQueue, TaskQueue bitReportTaskQueue, StateManager<BitIntegrityMorsel> state, int maxTaskQueueSize, Frequency frequency, NotificationManager notificationManager, PathFilterManager exclusionManager, LoopingBitTaskProducerConfigurationManager config) {
        super(credentialsRepo, storageProviderFactory, bitTaskQueue, state, maxTaskQueueSize, frequency, notificationManager, config);
        this.exclusionManager = exclusionManager;
        this.bitReportTaskQueue = bitReportTaskQueue;
        this.bitReportRepo = bitReportRepo;
    }

    @Override
    protected void loadMorselQueueFromSource(Queue<BitIntegrityMorsel> morselQueue) {
        try {
            for (String account : this.getAccountsList()) {
                String accountPath = "/" + account;
                log.debug("loading {}", (Object)account);
                if (this.exclusionManager.isExcluded(accountPath)) continue;
                AccountCredentials accountCreds = this.getCredentialsRepo().getAccountCredentials(account);
                for (StorageProviderCredentials cred : accountCreds.getProviderCredentials()) {
                    String storeId = cred.getProviderId();
                    String storePath = accountPath + "/" + storeId;
                    if (this.exclusionManager.isExcluded(storePath)) continue;
                    StorageProvider store = this.getStorageProvider(cred);
                    Iterator<String> spaces = store.getSpaces();
                    while (spaces.hasNext()) {
                        String spaceId = spaces.next();
                        String spacePath = storePath + "/" + spaceId;
                        if (this.exclusionManager.isExcluded(spacePath)) continue;
                        BitIntegrityReport report = this.bitReportRepo.findFirstByAccountAndStoreIdAndSpaceIdOrderByCompletionDateDesc(account, storeId, spaceId);
                        if (report != null) {
                            long oneDayInMs = 86400000L;
                            if (report.getCompletionDate().after(new Date(System.currentTimeMillis() - 60L * oneDayInMs)) && report.getResult().equals((Object)BitIntegrityReportResult.SUCCESS)) continue;
                        }
                        morselQueue.add(new BitIntegrityMorsel(account, cred.getProviderId(), cred.getProviderType().name(), spaceId));
                    }
                    log.info("loaded {} into morsel queue.", (Object)account);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new DuraCloudRuntimeException(e);
        }
    }

    private List<String> getAccountsList() throws CredentialsRepoException {
        return this.getCredentialsRepo().getActiveAccounts();
    }

    @Override
    protected void nibble(Queue<BitIntegrityMorsel> queue) {
        StorageProvider store;
        BitIntegrityMorsel morsel = queue.peek();
        String storeId = morsel.getStoreId();
        String account = morsel.getAccount();
        try {
            store = this.getStorageProvider(account, storeId);
        }
        catch (Exception ex) {
            if (morsel.getMarker() != null) {
                throw new DuraCloudRuntimeException("Failed to get storage provider for " + morsel + ". Morsel has already been nibbled. " + "Likely cause:  a storage provider was removed in the middle of processing the morsel. " + "Further investigation and clean up recommended before restarting the run." + "In most cases you should be able to remove the state file and restart the run.", ex);
            }
            queue.poll();
            String message = MessageFormat.format("Failed to get storage provider for {0}. Likely cause:  a storage provider was removed after the bit integrity run was started.  Since no tasks have been added yet for this morsel, we will simply skip it.  No further action required.", morsel);
            log.warn(message, (Object)morsel);
            this.sendEmail("Failed to get storage provider for " + morsel, message);
            return;
        }
        int maxTaskQueueSize = this.getMaxTaskQueueSize();
        int taskQueueSize = this.getTaskQueue().size();
        while (taskQueueSize < maxTaskQueueSize) {
            if (taskQueueSize >= maxTaskQueueSize) {
                log.info("Task queue size ({}) has reached or exceeded max size ({}).", (Object)taskQueueSize, (Object)maxTaskQueueSize);
            } else {
                if (this.addTasks(morsel, store, 1000)) {
                    log.info("All bit integrity tasks that could be created were created for account={}, storeId={}, spaceId={}. getTaskQueue().size = {}", morsel.getAccount(), storeId, morsel.getSpaceId(), this.getTaskQueue().size());
                    log.info("{} completely nibbled.", (Object)morsel);
                    log.debug("delay before checking the queue size in ms: {}", (Object)this.waitTimeInMsBeforeQueueSizeCheck);
                    this.sleep(this.waitTimeInMsBeforeQueueSizeCheck);
                    long size = this.getTaskQueue().sizeIncludingInvisibleAndDelayed().intValue();
                    if (size == 0L) {
                        this.addReportTaskProcessorTask(queue.poll());
                        break;
                    }
                    log.info("{} (queue) is not empty: {} items remain to be processed before creating report generation task.", (Object)this.getTaskQueue().getName(), (Object)size);
                    break;
                }
                log.info("morsel nibbled down: {}", (Object)morsel);
            }
            taskQueueSize = this.getTaskQueue().size();
        }
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void addReportTaskProcessorTask(BitIntegrityMorsel morsel) {
        BitIntegrityCheckReportTask task = new BitIntegrityCheckReportTask();
        task.setAccount(morsel.getAccount());
        task.setStoreId(morsel.getStoreId());
        task.setSpaceId(morsel.getSpaceId());
        Task t = task.writeTask();
        this.bitReportTaskQueue.put(t);
        log.info("added report task {} to {}", (Object)t, (Object)this.bitReportTaskQueue);
    }

    private boolean addTasks(BitIntegrityMorsel morsel, final StorageProvider store, final int biteSize) {
        String account = morsel.getAccount();
        String storeId = morsel.getStoreId();
        final String spaceId = morsel.getSpaceId();
        final String marker = morsel.getMarker();
        List contentIds = null;
        try {
            contentIds = (List)new Retrier(3, this.waitBetweenRetriesMs, 2).execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    return store.getSpaceContentsChunked(spaceId, null, biteSize, marker);
                }
            });
            int added = this.addToTaskQueue(account, storeId, spaceId, contentIds);
            ((BitIntegrityRunStats)this.getStats(account)).add(added);
            if (added == 0) {
                return true;
            }
            String newMarker = (String)contentIds.get(contentIds.size() - 1);
            morsel.setMarker(newMarker);
            return false;
        }
        catch (Exception ex) {
            String message = MessageFormat.format("Bit integrity producer failure on  subdomain={0}, spaceId={1}, storeId={2} due to: {3}", account, spaceId, storeId, ex.getMessage());
            log.error(message, ex);
            this.sendEmail(message, ex);
            return true;
        }
    }

    private int addToTaskQueue(String account, String storeId, String spaceId, List<String> contentIds) {
        HashSet<Task> tasks = new HashSet<Task>();
        int addedCount = 0;
        for (String contentId : contentIds) {
            BitIntegrityCheckTask bitIntegrityTask = new BitIntegrityCheckTask();
            bitIntegrityTask.setAccount(account);
            bitIntegrityTask.setContentId(contentId);
            bitIntegrityTask.setSpaceId(spaceId);
            bitIntegrityTask.setStoreId(storeId);
            Task task = bitIntegrityTask.writeTask();
            tasks.add(task);
            ++addedCount;
        }
        this.getTaskQueue().put(tasks);
        return addedCount;
    }

    @Override
    protected void logIncrementalStatsByAccount(String account, RunStats stats) {
        log.info("Session stats by account (incremental): account={} tasksAdded={}", (Object)account, (Object)((BitIntegrityRunStats)stats).getAdded());
    }

    @Override
    protected void logCumulativeSessionStats(Map<String, RunStats> runstats, RunStats cumulativeTotals) {
        log.info("session stats (global cumulative): domains={} tasksAdded={}", (Object)runstats.keySet().size(), (Object)((BitIntegrityRunStats)cumulativeTotals).getAdded());
    }

    @Override
    protected void logGlobalncrementalStats(RunStats incrementalTotals) {
        log.info("Session stats (global incremental): tasksAdded={}", (Object)((BitIntegrityRunStats)incrementalTotals).getAdded());
    }

    @Override
    protected RunStats createRunStats() {
        return new BitIntegrityRunStats();
    }

    public void setWaitTimeInMsBeforeQueueSizeCheck(int ms) {
        this.waitTimeInMsBeforeQueueSizeCheck = ms;
    }

    @Override
    protected String getLoopingProducerTypePrefix() {
        return "bit";
    }

    public void setWaitBetweenRetriesMs(int waitBetweenRetriesMs) {
        this.waitBetweenRetriesMs = waitBetweenRetriesMs;
    }
}

