/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.duracloud.mill.dup.DuplicationPolicy;
import org.duracloud.mill.dup.repo.DuplicationPolicyRepo;

public class DuplicationPolicyManager {
    private Map<String, DuplicationPolicy> dupAccounts = null;
    private DuplicationPolicyRepo policyRepo;

    public DuplicationPolicyManager(DuplicationPolicyRepo policyRepo) {
        this.policyRepo = policyRepo;
    }

    private void refreshPolicies() {
        this.dupAccounts = new HashMap<String, DuplicationPolicy>();
        try {
            List<String> dupAccountList = this.readDupAccounts(this.policyRepo.getDuplicationAccounts());
            for (String dupAccount : dupAccountList) {
                DuplicationPolicy policy = this.readDupPolicy(this.policyRepo.getDuplicationPolicy(dupAccount));
                this.dupAccounts.put(dupAccount, policy);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load duplication policies due to: " + e.getMessage(), e);
        }
    }

    private List<String> readDupAccounts(InputStream dupAccountsStream) throws IOException {
        ObjectMapper objMapper = new ObjectMapper();
        return (List)objMapper.readValue(dupAccountsStream, (TypeReference)new TypeReference<List<String>>(){});
    }

    private DuplicationPolicy readDupPolicy(InputStream dupPolicyStream) throws IOException {
        return DuplicationPolicy.unmarshall(dupPolicyStream);
    }

    public Set<String> getDuplicationAccounts() {
        this.ensurePoliciesLoaded();
        return new HashSet<String>(this.dupAccounts.keySet());
    }

    private synchronized void ensurePoliciesLoaded() {
        if (this.dupAccounts == null) {
            this.refreshPolicies();
        }
    }

    public DuplicationPolicy getDuplicationPolicy(String account) {
        this.ensurePoliciesLoaded();
        return this.dupAccounts.get(account);
    }

    public void clearPolicyCache() {
        this.dupAccounts = null;
    }
}

