/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.functions;

import com.google.common.base.Supplier;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.domain.AuthenticationResponse;

@Singleton
public class URIFromAuthenticationResponseForService
implements Supplier<URI> {
    private final Supplier<AuthenticationResponse> auth;
    private final String service;

    @Inject
    public URIFromAuthenticationResponseForService(Supplier<AuthenticationResponse> auth, @Assisted String service) {
        this.auth = auth;
        this.service = service;
    }

    @Override
    public URI get() {
        return this.auth.get().getServices().get(this.service);
    }

    public String toString() {
        return "getURIForService(" + this.service + ")";
    }

    public static interface Factory {
        public URIFromAuthenticationResponseForService create(String var1);
    }
}

