/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SendEmailRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String source;
    private Destination destination;
    private Message message;
    private SdkInternalList<String> replyToAddresses;
    private String returnPath;
    private String sourceArn;
    private String returnPathArn;

    public SendEmailRequest() {
    }

    public SendEmailRequest(String source, Destination destination, Message message) {
        this.setSource(source);
        this.setDestination(destination);
        this.setMessage(message);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public SendEmailRequest withSource(String source) {
        this.setSource(source);
        return this;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public SendEmailRequest withDestination(Destination destination) {
        this.setDestination(destination);
        return this;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public SendEmailRequest withMessage(Message message) {
        this.setMessage(message);
        return this;
    }

    public List<String> getReplyToAddresses() {
        if (this.replyToAddresses == null) {
            this.replyToAddresses = new SdkInternalList();
        }
        return this.replyToAddresses;
    }

    public void setReplyToAddresses(Collection<String> replyToAddresses) {
        if (replyToAddresses == null) {
            this.replyToAddresses = null;
            return;
        }
        this.replyToAddresses = new SdkInternalList<String>(replyToAddresses);
    }

    public SendEmailRequest withReplyToAddresses(String ... replyToAddresses) {
        if (this.replyToAddresses == null) {
            this.setReplyToAddresses(new SdkInternalList<String>(replyToAddresses.length));
        }
        for (String ele : replyToAddresses) {
            this.replyToAddresses.add(ele);
        }
        return this;
    }

    public SendEmailRequest withReplyToAddresses(Collection<String> replyToAddresses) {
        this.setReplyToAddresses(replyToAddresses);
        return this;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public SendEmailRequest withReturnPath(String returnPath) {
        this.setReturnPath(returnPath);
        return this;
    }

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public SendEmailRequest withSourceArn(String sourceArn) {
        this.setSourceArn(sourceArn);
        return this;
    }

    public void setReturnPathArn(String returnPathArn) {
        this.returnPathArn = returnPathArn;
    }

    public String getReturnPathArn() {
        return this.returnPathArn;
    }

    public SendEmailRequest withReturnPathArn(String returnPathArn) {
        this.setReturnPathArn(returnPathArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: " + this.getSource() + ",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: " + this.getDestination() + ",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: " + this.getMessage() + ",");
        }
        if (this.getReplyToAddresses() != null) {
            sb.append("ReplyToAddresses: " + this.getReplyToAddresses() + ",");
        }
        if (this.getReturnPath() != null) {
            sb.append("ReturnPath: " + this.getReturnPath() + ",");
        }
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: " + this.getSourceArn() + ",");
        }
        if (this.getReturnPathArn() != null) {
            sb.append("ReturnPathArn: " + this.getReturnPathArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEmailRequest)) {
            return false;
        }
        SendEmailRequest other = (SendEmailRequest)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getReplyToAddresses() == null ^ this.getReplyToAddresses() == null) {
            return false;
        }
        if (other.getReplyToAddresses() != null && !other.getReplyToAddresses().equals(this.getReplyToAddresses())) {
            return false;
        }
        if (other.getReturnPath() == null ^ this.getReturnPath() == null) {
            return false;
        }
        if (other.getReturnPath() != null && !other.getReturnPath().equals(this.getReturnPath())) {
            return false;
        }
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getReturnPathArn() == null ^ this.getReturnPathArn() == null) {
            return false;
        }
        return other.getReturnPathArn() == null || other.getReturnPathArn().equals(this.getReturnPathArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getReplyToAddresses() == null ? 0 : this.getReplyToAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getReturnPath() == null ? 0 : this.getReturnPath().hashCode());
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getReturnPathArn() == null ? 0 : this.getReturnPathArn().hashCode());
        return hashCode;
    }

    @Override
    public SendEmailRequest clone() {
        return (SendEmailRequest)super.clone();
    }
}

