/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import scala.Option;

public abstract class QueryExecutionConverters {
    private static final boolean SPRING_4_2_PRESENT = ClassUtils.isPresent("org.springframework.core.annotation.AnnotationConfigurationException", QueryExecutionConverters.class.getClassLoader());
    private static final boolean GUAVA_PRESENT = ClassUtils.isPresent("com.google.common.base.Optional", QueryExecutionConverters.class.getClassLoader());
    private static final boolean JDK_8_PRESENT = ClassUtils.isPresent("java.util.Optional", QueryExecutionConverters.class.getClassLoader());
    private static final boolean SCALA_PRESENT = ClassUtils.isPresent("scala.Option", QueryExecutionConverters.class.getClassLoader());
    private static final Set<Class<?>> WRAPPER_TYPES = new HashSet();
    private static final Set<Converter<Object, Object>> UNWRAPPERS = new HashSet<Converter<Object, Object>>();

    private QueryExecutionConverters() {
    }

    public static boolean supports(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        for (Class<?> candidate : WRAPPER_TYPES) {
            if (!candidate.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static void registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull(conversionService, "ConversionService must not be null!");
        if (GUAVA_PRESENT) {
            conversionService.addConverter(new NullableWrapperToGuavaOptionalConverter(conversionService));
        }
        if (JDK_8_PRESENT) {
            conversionService.addConverter(new NullableWrapperToJdk8OptionalConverter(conversionService));
            conversionService.addConverter(new NullableWrapperToCompletableFutureConverter(conversionService));
        }
        if (SCALA_PRESENT) {
            conversionService.addConverter(new NullableWrapperToScalaOptionConverter(conversionService));
        }
        conversionService.addConverter(new NullableWrapperToFutureConverter(conversionService));
    }

    public static Object unwrap(Object source) {
        if (source == null || !QueryExecutionConverters.supports(source.getClass())) {
            return source;
        }
        for (Converter<Object, Object> converter : UNWRAPPERS) {
            Object result = converter.convert(source);
            if (result == source) continue;
            return result;
        }
        return source;
    }

    static {
        WRAPPER_TYPES.add(Future.class);
        WRAPPER_TYPES.add(ListenableFuture.class);
        if (GUAVA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToGuavaOptionalConverter.getWrapperType());
            UNWRAPPERS.add(GuavaOptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToJdk8OptionalConverter.getWrapperType());
            UNWRAPPERS.add(Jdk8OptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT && SPRING_4_2_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToCompletableFutureConverter.getWrapperType());
        }
        if (SCALA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToScalaOptionConverter.getWrapperType());
            UNWRAPPERS.add(ScalOptionUnwrapper.INSTANCE);
        }
    }

    private static enum ScalOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source) {
            return source instanceof Option ? ((Option)source).orNull(null) : source;
        }
    }

    private static enum Jdk8OptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source) {
            return source instanceof Optional ? ((Optional)source).orElse(null) : source;
        }
    }

    private static enum GuavaOptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source) {
            return source instanceof com.google.common.base.Optional ? ((com.google.common.base.Optional)source).orNull() : source;
        }
    }

    private static class NullableWrapperToScalaOptionConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToScalaOptionConverter(ConversionService conversionService) {
            super(conversionService, Option.empty(), Option.class);
        }

        @Override
        protected Object wrap(Object source) {
            return Option.apply((Object)source);
        }

        public static Class<?> getWrapperType() {
            return Option.class;
        }
    }

    private static class NullableWrapperToCompletableFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToCompletableFutureConverter(ConversionService conversionService) {
            super(conversionService, CompletableFuture.completedFuture(null), CompletableFuture.class);
        }

        @Override
        protected Object wrap(Object source) {
            return source instanceof CompletableFuture ? source : CompletableFuture.completedFuture(source);
        }

        public static Class<?> getWrapperType() {
            return CompletableFuture.class;
        }
    }

    private static class NullableWrapperToFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToFutureConverter(ConversionService conversionService) {
            super(conversionService, new AsyncResult<Object>(null), Future.class, ListenableFuture.class);
        }

        @Override
        protected Object wrap(Object source) {
            return new AsyncResult<Object>(source);
        }
    }

    private static class NullableWrapperToJdk8OptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToJdk8OptionalConverter(ConversionService conversionService) {
            super(conversionService, Optional.empty(), Optional.class);
        }

        @Override
        protected Object wrap(Object source) {
            return Optional.of(source);
        }

        public static Class<?> getWrapperType() {
            return Optional.class;
        }
    }

    private static class NullableWrapperToGuavaOptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToGuavaOptionalConverter(ConversionService conversionService) {
            super(conversionService, com.google.common.base.Optional.absent(), com.google.common.base.Optional.class);
        }

        @Override
        protected Object wrap(Object source) {
            return com.google.common.base.Optional.of(source);
        }

        public static Class<?> getWrapperType() {
            return com.google.common.base.Optional.class;
        }
    }

    private static abstract class AbstractWrapperTypeConverter
    implements GenericConverter {
        private final ConversionService conversionService;
        private final Class<?>[] wrapperTypes;
        private final Object nullValue;

        protected AbstractWrapperTypeConverter(ConversionService conversionService, Object nullValue, Class<?> ... wrapperTypes) {
            Assert.notNull(conversionService, "ConversionService must not be null!");
            Assert.notEmpty(wrapperTypes, "Wrapper type must not be empty!");
            this.conversionService = conversionService;
            this.wrapperTypes = wrapperTypes;
            this.nullValue = nullValue;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>(this.wrapperTypes.length);
            for (Class<?> wrapperType : this.wrapperTypes) {
                pairs.add(new GenericConverter.ConvertiblePair(NullableWrapper.class, wrapperType));
            }
            return Collections.unmodifiableSet(pairs);
        }

        @Override
        public final Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            NullableWrapper wrapper = (NullableWrapper)source;
            Object value = wrapper.getValue();
            return value == null ? this.nullValue : this.wrap(value);
        }

        protected abstract Object wrap(Object var1);
    }
}

