/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.CountingOutputStream;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.jclouds.JcloudsVersion;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;

@Singleton
public class JavaUrlHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HttpURLConnection> {
    public static final String DEFAULT_USER_AGENT = String.format("jclouds/%s java/%s", JcloudsVersion.get(), System.getProperty("java.version"));
    protected final Supplier<SSLContext> untrustedSSLContextProvider;
    protected final Function<URI, Proxy> proxyForURI;
    protected final HostnameVerifier verifier;
    @Inject(optional=true)
    protected Supplier<SSLContext> sslContextSupplier;

    @Inject
    public JavaUrlHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI) throws SecurityException, NoSuchFieldException {
        super(utils, contentMetadataCodec, ioExecutor, retryHandler, ioRetryHandler, errorHandler, wire);
        if (utils.getMaxConnections() > 0) {
            System.setProperty("http.maxConnections", String.valueOf(Preconditions.checkNotNull(utils, "utils").getMaxConnections()));
        }
        this.untrustedSSLContextProvider = Preconditions.checkNotNull(untrustedSSLContextProvider, "untrustedSSLContextProvider");
        this.verifier = Preconditions.checkNotNull(verifier, "verifier");
        this.proxyForURI = Preconditions.checkNotNull(proxyForURI, "proxyForURI");
    }

    @Override
    protected HttpResponse invoke(HttpURLConnection connection) throws IOException, InterruptedException {
        HttpResponse.Builder<?> builder = HttpResponse.builder();
        InputStream in = null;
        try {
            in = connection.getInputStream();
        }
        catch (IOException e) {
            in = this.bufferAndCloseStream(connection.getErrorStream());
        }
        catch (RuntimeException e) {
            Closeables.close(in, true);
            throw Throwables.propagate(e);
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 204) {
            Closeables.close(in, true);
            in = null;
        }
        builder.statusCode(responseCode);
        builder.message(connection.getResponseMessage());
        ImmutableMultimap.Builder headerBuilder = ImmutableMultimap.builder();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            String header = entry.getKey();
            if (header == null) continue;
            headerBuilder.putAll(header, (Iterable)entry.getValue());
        }
        ImmutableMultimap<String, String> headers = headerBuilder.build();
        if (in != null) {
            InputStreamPayload payload = Payloads.newInputStreamPayload(in);
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), headers);
            builder.payload(payload);
        }
        builder.headers(HttpUtils.filterOutContentHeaders(headers));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream bufferAndCloseStream(InputStream inputStream) throws IOException {
        ByteArrayInputStream in = null;
        try {
            if (inputStream != null) {
                in = new ByteArrayInputStream(ByteStreams.toByteArray(inputStream));
            }
        }
        finally {
            Closeables.close(inputStream, true);
        }
        return in;
    }

    @Override
    protected HttpURLConnection convert(HttpRequest request) throws IOException, InterruptedException {
        Payload payload;
        boolean chunked = "chunked".equals(request.getFirstHeaderOrNull("Transfer-Encoding"));
        HttpURLConnection connection = this.initConnection(request);
        connection.setConnectTimeout(this.utils.getConnectionTimeout());
        connection.setReadTimeout(this.utils.getSocketOpenTimeout());
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(false);
        this.setRequestMethodBypassingJREMethodLimitation(connection, request.getMethod());
        this.configureRequestHeaders(connection, request);
        String host = request.getEndpoint().getHost();
        if (request.getEndpoint().getPort() != -1) {
            host = host + ":" + request.getEndpoint().getPort();
        }
        connection.setRequestProperty("Host", host);
        if (connection.getRequestProperty("User-Agent") == null) {
            connection.setRequestProperty("User-Agent", DEFAULT_USER_AGENT);
        }
        if ((payload = request.getPayload()) != null) {
            MutableContentMetadata md = payload.getContentMetadata();
            for (Map.Entry<String, String> entry : this.contentMetadataCodec.toHeaders(md).entries()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (chunked) {
                connection.setChunkedStreamingMode(8196);
                this.writePayloadToConnection(payload, "streaming", connection);
            } else {
                Long length = Preconditions.checkNotNull(md.getContentLength(), "payload.getContentLength");
                Preconditions.checkArgument(length <= Integer.MAX_VALUE, "Cannot transfer 2 GB or larger chunks due to JDK 1.6 limitations. Use chunked encoding or multi-part upload, if possible. For more information: http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6755625");
                if (length > 0L) {
                    connection.setRequestProperty("Content-Length", length.toString());
                    connection.setFixedLengthStreamingMode(length.intValue());
                    this.writePayloadToConnection(payload, length, connection);
                } else {
                    this.writeNothing(connection);
                }
            }
        } else {
            this.writeNothing(connection);
        }
        return connection;
    }

    protected HttpURLConnection initConnection(HttpRequest request) throws IOException {
        URL url = request.getEndpoint().toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxyForURI.apply(request.getEndpoint()));
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection sslCon = (HttpsURLConnection)connection;
            if (this.utils.relaxHostname()) {
                sslCon.setHostnameVerifier(this.verifier);
            }
            if (this.sslContextSupplier != null) {
                sslCon.setSSLSocketFactory(this.sslContextSupplier.get().getSocketFactory());
            } else if (this.utils.trustAllCerts()) {
                sslCon.setSSLSocketFactory(this.untrustedSSLContextProvider.get().getSocketFactory());
            }
        }
        return connection;
    }

    protected void configureRequestHeaders(HttpURLConnection connection, HttpRequest request) {
        for (Map.Entry<String, String> entry : request.getHeaders().entries()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private void setRequestMethodBypassingJREMethodLimitation(HttpURLConnection httpURLConnection, String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            Class<?> connectionClass = httpURLConnection.getClass();
            Field delegateField = null;
            try {
                delegateField = connectionClass.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                HttpURLConnection delegateConnection = (HttpURLConnection)delegateField.get(httpURLConnection);
                this.setRequestMethodBypassingJREMethodLimitation(delegateConnection, method);
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalArgumentException e) {
                this.logger.error(e, "could not set request method: ", method);
                Throwables.propagate(e);
            }
            catch (IllegalAccessException e) {
                this.logger.error(e, "could not set request method: ", method);
                Throwables.propagate(e);
            }
            try {
                Field methodField = null;
                while (connectionClass != null) {
                    try {
                        methodField = connectionClass.getDeclaredField("method");
                    }
                    catch (NoSuchFieldException e) {
                        connectionClass = connectionClass.getSuperclass();
                        continue;
                    }
                    methodField.setAccessible(true);
                    methodField.set(httpURLConnection, method);
                }
            }
            catch (Exception e) {
                this.logger.error(e, "could not set request method: ", method);
                Throwables.propagate(e);
            }
        }
    }

    protected void writeNothing(HttpURLConnection connection) {
        if (!HttpRequest.NON_PAYLOAD_METHODS.contains(connection.getRequestMethod())) {
            connection.setRequestProperty("Content-Length", "0");
            String method = connection.getRequestMethod();
            if ("POST".equals(method) || "PUT".equals(method)) {
                connection.setFixedLengthStreamingMode(0);
                connection.setDoOutput(true);
            }
        }
    }

    void writePayloadToConnection(Payload payload, Object lengthDesc, HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        CountingOutputStream out = new CountingOutputStream(connection.getOutputStream());
        InputStream is = payload.openStream();
        try {
            ByteStreams.copy(is, (OutputStream)out);
        }
        catch (IOException e) {
            this.logger.error(e, "error after writing %d/%s bytes to %s", out.getCount(), lengthDesc, connection.getURL());
            throw e;
        }
        finally {
            Closeables.closeQuietly(is);
        }
    }

    @Override
    protected void cleanup(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }
}

