/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequest;
import org.springframework.http.client.HttpComponentsStreamingClientHttpRequest;
import org.springframework.util.Assert;

public class HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private HttpClient httpClient;
    private RequestConfig requestConfig;
    private boolean bufferRequestBody = true;

    public HttpComponentsClientHttpRequestFactory() {
        this(HttpClients.createSystem());
    }

    public HttpComponentsClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull(httpClient, "HttpClient must not be null");
        this.httpClient = httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectTimeout(int timeout) {
        Assert.isTrue(timeout >= 0, "Timeout must be a non-negative value");
        this.requestConfig = this.requestConfigBuilder().setConnectTimeout(timeout).build();
        this.setLegacyConnectionTimeout(this.getHttpClient(), timeout);
    }

    private void setLegacyConnectionTimeout(HttpClient client, int timeout) {
        if (AbstractHttpClient.class.isInstance(client)) {
            client.getParams().setIntParameter("http.connection.timeout", timeout);
        }
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.requestConfig = this.requestConfigBuilder().setConnectionRequestTimeout(connectionRequestTimeout).build();
    }

    public void setReadTimeout(int timeout) {
        Assert.isTrue(timeout >= 0, "Timeout must be a non-negative value");
        this.requestConfig = this.requestConfigBuilder().setSocketTimeout(timeout).build();
        this.setLegacySocketTimeout(this.getHttpClient(), timeout);
    }

    private void setLegacySocketTimeout(HttpClient client, int timeout) {
        if (AbstractHttpClient.class.isInstance(client)) {
            client.getParams().setIntParameter("http.socket.timeout", timeout);
        }
    }

    public void setBufferRequestBody(boolean bufferRequestBody) {
        this.bufferRequestBody = bufferRequestBody;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpClient client = this.getHttpClient();
        Assert.state(client != null, "Synchronous execution requires an HttpClient to be set");
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        if (context.getAttribute("http.request-config") == null) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                config = ((Configurable)((Object)httpRequest)).getConfig();
            }
            if (config == null) {
                config = this.createRequestConfig(client);
            }
            if (config != null) {
                context.setAttribute("http.request-config", config);
            }
        }
        if (this.bufferRequestBody) {
            return new HttpComponentsClientHttpRequest(client, httpRequest, context);
        }
        return new HttpComponentsStreamingClientHttpRequest(client, httpRequest, context);
    }

    private RequestConfig.Builder requestConfigBuilder() {
        return this.requestConfig != null ? RequestConfig.copy(this.requestConfig) : RequestConfig.custom();
    }

    protected RequestConfig createRequestConfig(Object client) {
        if (client instanceof Configurable) {
            RequestConfig clientRequestConfig = ((Configurable)client).getConfig();
            return this.mergeRequestConfig(clientRequestConfig);
        }
        return this.requestConfig;
    }

    protected RequestConfig mergeRequestConfig(RequestConfig clientConfig) {
        int socketTimeout;
        int connectionRequestTimeout;
        if (this.requestConfig == null) {
            return clientConfig;
        }
        RequestConfig.Builder builder = RequestConfig.copy(clientConfig);
        int connectTimeout = this.requestConfig.getConnectTimeout();
        if (connectTimeout >= 0) {
            builder.setConnectTimeout(connectTimeout);
        }
        if ((connectionRequestTimeout = this.requestConfig.getConnectionRequestTimeout()) >= 0) {
            builder.setConnectionRequestTimeout(connectionRequestTimeout);
        }
        if ((socketTimeout = this.requestConfig.getSocketTimeout()) >= 0) {
            builder.setSocketTimeout(socketTimeout);
        }
        return builder.build();
    }

    protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(uri);
            }
            case HEAD: {
                return new HttpHead(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case PATCH: {
                return new HttpPatch(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case TRACE: {
                return new HttpTrace(uri);
            }
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + (Object)((Object)httpMethod));
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
    }

    protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
        return null;
    }

    @Override
    public void destroy() throws Exception {
        if (this.httpClient instanceof Closeable) {
            ((Closeable)((Object)this.httpClient)).close();
        }
    }

    private static class HttpDelete
    extends HttpEntityEnclosingRequestBase {
        public HttpDelete(URI uri) {
            this.setURI(uri);
        }

        @Override
        public String getMethod() {
            return "DELETE";
        }
    }
}

