/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class AuthorizationHelper {
    private final Logger log = LoggerFactory.getLogger(AuthorizationHelper.class);
    private StorageProviderFactory storageProviderFactory;

    public AuthorizationHelper(StorageProviderFactory storageProviderFactory) {
        this.storageProviderFactory = storageProviderFactory;
    }

    public List<String> getUserGroups(Authentication auth) {
        DuracloudUserDetails userDetails = this.getUserDetails(auth);
        return userDetails.getGroups();
    }

    protected DuracloudUserDetails getUserDetails(Authentication auth) {
        DuracloudUserDetails userDetails = (DuracloudUserDetails)auth.getPrincipal();
        return userDetails;
    }

    public Collection<GrantedAuthority> getAuthorities(Authentication auth) {
        DuracloudUserDetails userDetails = this.getUserDetails(auth);
        return userDetails.getAuthorities();
    }

    public boolean groupsHaveReadAccess(Authentication auth, Map<String, AclType> acls) {
        return this.groupsHaveAccess(this.getUserGroups(auth), acls, true);
    }

    public boolean groupsHaveReadAccess(List<String> userGroups, Map<String, AclType> acls) {
        return this.groupsHaveAccess(userGroups, acls, true);
    }

    public boolean groupsHaveWriteAccess(List<String> userGroups, Map<String, AclType> acls) {
        return this.groupsHaveAccess(userGroups, acls, false);
    }

    public boolean groupsHaveAccess(List<String> userGroups, Map<String, AclType> acls, boolean isRead) {
        if (null != userGroups) {
            for (String group : userGroups) {
                if (isRead && this.hasReadAccess(group, acls)) {
                    return true;
                }
                if (isRead || !this.hasWriteAccess(group, acls)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasReadAccess(String name, Map<String, AclType> acls) {
        return this.hasAccess(name, acls, true);
    }

    public boolean hasWriteAccess(String name, Map<String, AclType> acls) {
        return this.hasAccess(name, acls, false);
    }

    private boolean hasAccess(String name, Map<String, AclType> acls, boolean isRead) {
        if (null == acls) {
            return false;
        }
        String aclName = "acl-" + name;
        if (acls.containsKey(aclName)) {
            AclType acl = acls.get(aclName);
            if (isRead) {
                return AclType.READ.equals((Object)acl) || AclType.WRITE.equals((Object)acl);
            }
            return AclType.WRITE.equals((Object)acl);
        }
        return false;
    }

    public boolean hasRole(Authentication auth, String role) {
        Collection<GrantedAuthority> authorities = this.getAuthorities(auth);
        return this.hasRole(role, authorities);
    }

    public boolean hasAdmin(Authentication auth) {
        return this.hasRole(auth, "ROLE_ADMIN");
    }

    public boolean hasRole(String role, Collection<GrantedAuthority> authorities) {
        for (GrantedAuthority authority : authorities) {
            if (!role.equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public Map<String, AclType> getSpaceACLs(String storeId, String spaceId) {
        HashMap<String, AclType> emptyACLs = new HashMap<String, AclType>();
        if (null == spaceId) {
            return emptyACLs;
        }
        if (spaceId.equals("security") || spaceId.equals("init")) {
            return emptyACLs;
        }
        StorageProvider store = this.storageProviderFactory.getStorageProvider(storeId);
        if (null == store) {
            return emptyACLs;
        }
        try {
            return store.getSpaceACLs(spaceId);
        }
        catch (NotFoundException nfe) {
            this.log.info("Space !exist: {}, exception: {}", (Object)spaceId, (Object)nfe);
            return emptyACLs;
        }
        catch (StorageException e) {
            this.log.warn("Error getting space ACLs: {}, exception: {}", (Object)spaceId, (Object)e);
            return emptyACLs;
        }
    }
}

