/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.joda;

import java.util.Date;
import java.util.Locale;
import javax.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Singleton
public class JodaDateService
implements DateService {
    private static final DateTimeFormatter rfc822DateFormatter = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.forID("GMT"));
    private static final DateTimeFormatter cDateFormatter = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.US).withZone(DateTimeZone.forID("GMT"));
    private static final DateTimeFormatter iso8601SecondsDateFormatter = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssZ").withLocale(Locale.US).withZone(DateTimeZone.forID("GMT"));
    private static final DateTimeFormatter iso8601DateFormatter = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withLocale(Locale.US).withZone(DateTimeZone.forID("GMT"));
    private static final DateTimeFormatter rfc1123DateFormat = DateTimeFormat.forPattern("EEE, dd MMM yyyyy HH:mm:ss Z").withLocale(Locale.US).withZone(DateTimeZone.forID("GMT"));

    public final Date fromSeconds(long seconds) {
        return new Date(seconds * 1000L);
    }

    @Override
    public final String cDateFormat(Date dateTime) {
        return cDateFormatter.print(new DateTime(dateTime));
    }

    @Override
    public final String cDateFormat() {
        return this.cDateFormat(new Date());
    }

    @Override
    public final Date cDateParse(String toParse) {
        return cDateFormatter.parseDateTime(toParse).toDate();
    }

    @Override
    public final String rfc822DateFormat(Date dateTime) {
        return rfc822DateFormatter.print(new DateTime(dateTime));
    }

    @Override
    public final String rfc822DateFormat() {
        return this.rfc822DateFormat(new Date());
    }

    @Override
    public final Date rfc822DateParse(String toParse) {
        return rfc822DateFormatter.parseDateTime(toParse).toDate();
    }

    @Override
    public final String iso8601SecondsDateFormat(Date dateTime) {
        String parsed = iso8601SecondsDateFormatter.print(new DateTime(dateTime));
        String tz = DateUtils.findTZ(parsed);
        if (tz.equals("+0000")) {
            parsed = DateUtils.trimTZ(parsed) + "Z";
        }
        return parsed;
    }

    @Override
    public final String iso8601SecondsDateFormat() {
        return this.iso8601SecondsDateFormat(new Date());
    }

    @Override
    public final String iso8601DateFormat(Date date) {
        String parsed = iso8601DateFormatter.print(new DateTime(date));
        String tz = DateUtils.findTZ(parsed);
        if (tz.equals("+0000")) {
            parsed = DateUtils.trimTZ(parsed) + "Z";
        }
        return parsed;
    }

    @Override
    public final String iso8601DateFormat() {
        return this.iso8601DateFormat(new Date());
    }

    @Override
    public final Date iso8601DateParse(String toParse) {
        if (toParse.length() < 10) {
            throw new IllegalArgumentException("incorrect date format " + toParse);
        }
        if ((toParse = this.adjustTz(toParse)).charAt(10) == ' ') {
            toParse = new StringBuilder(toParse).replace(10, 11, "T").toString();
        }
        return iso8601DateFormatter.parseDateTime(toParse).toDate();
    }

    private String adjustTz(String toParse) {
        String tz = DateUtils.findTZ(toParse);
        toParse = DateUtils.trimToMillis(toParse);
        toParse = DateUtils.trimTZ(toParse);
        toParse = toParse + tz;
        return toParse.replace("UTC", "");
    }

    @Override
    public final Date iso8601SecondsDateParse(String toParse) {
        if (toParse.length() < 10) {
            throw new IllegalArgumentException("incorrect date format " + toParse);
        }
        toParse = this.adjustTz(toParse);
        return iso8601SecondsDateFormatter.parseDateTime(toParse).toDate();
    }

    @Override
    public Date iso8601DateOrSecondsDateParse(String toParse) throws IllegalArgumentException {
        try {
            return this.iso8601DateParse(toParse);
        }
        catch (IllegalArgumentException orig) {
            try {
                return this.iso8601SecondsDateParse(toParse);
            }
            catch (IllegalArgumentException ignored) {
                throw orig;
            }
        }
    }

    @Override
    public final String rfc1123DateFormat(Date dateTime) {
        return rfc1123DateFormat.print(new DateTime(dateTime));
    }

    @Override
    public final String rfc1123DateFormat() {
        return this.rfc1123DateFormat(new Date());
    }

    @Override
    public final Date rfc1123DateParse(String toParse) {
        return rfc1123DateFormat.parseDateTime(toParse).toDate();
    }
}

