/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.io.File;
import java.net.FileNameMap;
import java.net.URLConnection;

public class MimetypeUtil {
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private FileNameMap fileNameMap = URLConnection.getFileNameMap();

    public String getMimeType(File file) {
        if (file == null) {
            return DEFAULT_MIMETYPE;
        }
        return this.getMimeType(file.getName());
    }

    public String getMimeType(String fileName) {
        if (fileName == null) {
            return DEFAULT_MIMETYPE;
        }
        String mimetype = this.fileNameMap.getContentTypeFor(fileName);
        if (mimetype == null) {
            return DEFAULT_MIMETYPE;
        }
        return mimetype;
    }
}

