/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.StreamingDistributionSummary;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.GetUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetUrlTaskResult;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUrlTaskRunner
extends BaseStreamingTaskRunner {
    private final Logger log = LoggerFactory.getLogger(GetUrlTaskRunner.class);
    private static final String TASK_NAME = "get-url";

    public GetUrlTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonCloudFrontClient cfClient) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.cfClient = cfClient;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        GetUrlTaskParameters taskParams = GetUrlTaskParameters.deserialize(taskParameters);
        String spaceId = taskParams.getSpaceId();
        String contentId = taskParams.getContentId();
        String resourcePrefix = taskParams.getResourcePrefix();
        this.log.info("Performing get-url task with parameters: spaceId=" + spaceId + ", contentId=" + contentId + ", resourcePrefix=" + resourcePrefix);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        GetUrlTaskResult taskResult = new GetUrlTaskResult();
        this.checkThatStreamingServiceIsEnabled(this.s3Provider, spaceId, TASK_NAME);
        StreamingDistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (null == existingDist) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-url task can only be used after a space has been configured to enable open streaming. Use enable-streaming to enable open streaming on this space.");
        }
        String domainName = existingDist.getDomainName();
        if (!existingDist.getTrustedSigners().getItems().isEmpty()) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-url task cannot be used to request a stream from a secure distribution. Use get-signed-url instead.");
        }
        String resourceId = contentId;
        if (null != resourcePrefix && !resourcePrefix.equals("")) {
            resourceId = resourcePrefix + contentId;
        }
        taskResult.setStreamUrl("rtmp://" + domainName + "/cfx/st/" + resourceId);
        String toReturn = taskResult.serialize();
        this.log.info("Result of get-url task: " + toReturn);
        return toReturn;
    }
}

