/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFilterManager {
    private static final Logger log = LoggerFactory.getLogger(PathFilterManager.class);
    private List<String> exclusions;
    private List<String> inclusions;

    public void setExclusions(File file) {
        this.checkFileParam(file);
        this.exclusions = this.loadPatterns(file, "exclusion");
    }

    public void setInclusions(File file) {
        this.checkFileParam(file);
        this.inclusions = this.loadPatterns(file, "inclusion");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadPatterns(File file, String type) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            LineIterator it = new LineIterator(r);
            ArrayList<String> patterns = new ArrayList<String>();
            while (it.hasNext()) {
                String pattern = it.next();
                if (pattern.startsWith("#")) continue;
                this.addPattern(type, patterns, pattern);
            }
            ArrayList<String> arrayList = patterns;
            return arrayList;
        }
        catch (Exception ex) {
            throw new DuraCloudRuntimeException(ex);
        }
    }

    private void addPattern(String type, List<String> patterns, String pattern) {
        pattern = this.validateAndScrubPattern(pattern);
        patterns.add(pattern);
        log.info("Added " + type + " pattern: {}", (Object)pattern);
    }

    private String validateAndScrubPattern(String pattern) {
        String regex = "(/([*]|[A-Za-z0-9_.-]+[*]?)){3}";
        if (!StringUtils.isEmpty(pattern) && pattern.matches(regex)) {
            return pattern.trim();
        }
        throw new DuraCloudRuntimeException("pattern \"" + pattern + "\" is invalid. Must be start with a forward slash, contain three slashes, and after each slash must be at least one alpha numeric charactor or * character.");
    }

    private void checkFileParam(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must be non-null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not exist");
        }
    }

    public boolean isExcluded(String path) {
        if (this.inclusions != null && !this.inclusions.isEmpty() && !this.matchesList(path, this.inclusions, false)) {
            log.debug("{} does not match an inclusion: skipping...", (Object)path);
            return true;
        }
        if (this.exclusions == null) {
            return false;
        }
        if (this.matchesList(path, this.exclusions, true)) {
            log.debug("{} matches exclusions: skipping...", (Object)path);
            return true;
        }
        return false;
    }

    private boolean matchesList(String path, List<String> list, boolean matchAllSegments) {
        for (String pattern : list) {
            if (!this.matches(pattern, path, matchAllSegments)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String pattern, String path, boolean matchAllSegments) {
        String[] pathSegments = path.substring(1).split("/");
        String[] patternSegments = pattern.substring(1).split("/");
        for (int i = 0; i < pathSegments.length; ++i) {
            boolean entireSegmentIsWild;
            String pathSegment = pathSegments[i].trim();
            String patternSegment = patternSegments[i].trim();
            boolean endsWithWildCard = patternSegment.endsWith("*");
            boolean bl = entireSegmentIsWild = endsWithWildCard && patternSegment.length() == 1;
            if (entireSegmentIsWild || !(endsWithWildCard ? !pathSegment.startsWith(patternSegment = patternSegment.substring(0, patternSegment.length() - 1)) : !pathSegment.equals(patternSegment))) continue;
            return false;
        }
        if (matchAllSegments && pathSegments.length != patternSegments.length) {
            int diff = patternSegments.length - pathSegments.length;
            int lowerBound = patternSegments.length - diff;
            for (int i = patternSegments.length - 1; i >= lowerBound; --i) {
                if (patternSegments[i].equals("*")) continue;
                return false;
            }
        }
        return true;
    }
}

