/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.CloudFrontUrlSigner;
import com.amazonaws.services.cloudfront.model.StreamingDistributionSummary;
import com.amazonaws.services.cloudfront.util.SignerUtils;
import java.io.File;
import java.io.IOException;
import java.security.spec.InvalidKeySpecException;
import java.util.Calendar;
import org.duracloud.common.util.IOUtil;
import org.duracloud.s3storage.S3ProviderUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.GetSignedUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetSignedUrlTaskResult;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class GetSignedUrlTaskRunner
extends BaseStreamingTaskRunner {
    public static final int DEFAULT_MINUTES_TO_EXPIRE = 480;
    private final Logger log = LoggerFactory.getLogger(GetSignedUrlTaskRunner.class);
    private static final String TASK_NAME = "get-signed-url";

    public GetSignedUrlTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonCloudFrontClient cfClient, String cfKeyId, String cfKeyPath) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.cfClient = cfClient;
        this.cfKeyId = cfKeyId;
        this.cfKeyPath = cfKeyPath.trim();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        GetSignedUrlTaskParameters taskParams = GetSignedUrlTaskParameters.deserialize(taskParameters);
        String spaceId = taskParams.getSpaceId();
        String contentId = taskParams.getContentId();
        String resourcePrefix = taskParams.getResourcePrefix();
        String ipAddress = taskParams.getIpAddress();
        int minutesToExpire = taskParams.getMinutesToExpire();
        if (minutesToExpire <= 0) {
            minutesToExpire = 480;
        }
        this.log.info("Performing get-signed-url task with parameters: spaceId=" + spaceId + ", contentId=" + contentId + ", resourcePrefix=" + resourcePrefix + ", minutesToExpire=" + minutesToExpire + ", ipAddress=" + ipAddress);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        GetSignedUrlTaskResult taskResult = new GetSignedUrlTaskResult();
        this.checkThatStreamingServiceIsEnabled(spaceId, TASK_NAME);
        StreamingDistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (null == existingDist) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-signed-url task can only be used after a space has been configured to enable secure streaming. Use enable-streaming to enable secure streaming on this space.");
        }
        String domainName = existingDist.getDomainName();
        if (existingDist.getTrustedSigners().getItems().isEmpty()) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-signed-url task cannot be used to request a stream from an open distribution. Use get-url instead.");
        }
        if (null == resourcePrefix) {
            resourcePrefix = "";
        }
        Calendar expireCalendar = Calendar.getInstance();
        expireCalendar.add(12, minutesToExpire);
        try {
            File cfKeyPathFile = this.getCfKeyPathFile(this.cfKeyPath);
            String signedUrl = CloudFrontUrlSigner.getSignedURLWithCustomPolicy(SignerUtils.Protocol.rtmp, domainName, cfKeyPathFile, contentId, this.cfKeyId, expireCalendar.getTime(), null, ipAddress);
            taskResult.setSignedUrl("rtmp://" + domainName + "/cfx/st/" + resourcePrefix + signedUrl);
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new RuntimeException("Error encountered attempting to sign URL for task get-signed-url: " + e.getMessage(), e);
        }
        String toReturn = taskResult.serialize();
        this.log.info("Result of get-signed-url task: " + toReturn);
        return toReturn;
    }

    private File getCfKeyPathFile(String cfKeyPath) throws IOException {
        if (this.cfKeyPath.startsWith("s3://")) {
            File keyFile = new File(System.getProperty("java.io.tmpdir"), "cloudfront-key.der");
            if (!keyFile.exists()) {
                Resource resource = S3ProviderUtil.getS3ObjectByUrl(this.cfKeyPath);
                File tmpFile = IOUtil.writeStreamToFile(resource.getInputStream());
                tmpFile.renameTo(keyFile);
                keyFile.deleteOnExit();
            }
            return keyFile;
        }
        return new File(this.cfKeyPath);
    }
}

