/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaminghls;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.DistributionSummary;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.GetHlsUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetUrlTaskResult;
import org.duracloud.s3task.streaminghls.BaseHlsTaskRunner;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUrlHlsTaskRunner
extends BaseHlsTaskRunner {
    private final Logger log = LoggerFactory.getLogger(GetUrlHlsTaskRunner.class);
    private static final String TASK_NAME = "get-url-hls";

    public GetUrlHlsTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonCloudFrontClient cfClient) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.cfClient = cfClient;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        GetHlsUrlTaskParameters taskParams = GetHlsUrlTaskParameters.deserialize(taskParameters);
        String spaceId = taskParams.getSpaceId();
        String contentId = taskParams.getContentId();
        this.log.info("Performing get-url-hls task with parameters: spaceId=" + spaceId + ", contentId=" + contentId);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        GetUrlTaskResult taskResult = new GetUrlTaskResult();
        this.checkThatStreamingServiceIsEnabled(spaceId, TASK_NAME);
        DistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (null == existingDist) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-url-hls task can only be used after a space has been configured to enable HLS streaming. Use enable-hls to enable HLS streaming on this space.");
        }
        String domainName = existingDist.getDomainName();
        taskResult.setStreamUrl("https://" + domainName + "/" + contentId);
        String toReturn = taskResult.serialize();
        this.log.info("Result of get-url-hls task: " + toReturn);
        return toReturn;
    }
}

