/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CustomRepositoryImplementationDetector {
    private static final String CUSTOM_IMPLEMENTATION_RESOURCE_PATTERN = "**/*%s.class";
    private final MetadataReaderFactory metadataReaderFactory;
    private final Environment environment;
    private final ResourceLoader resourceLoader;

    public CustomRepositoryImplementationDetector(MetadataReaderFactory metadataReaderFactory, Environment environment, ResourceLoader resourceLoader) {
        Assert.notNull(metadataReaderFactory, "MetadataReaderFactory must not be null!");
        Assert.notNull(resourceLoader, "ResourceLoader must not be null!");
        Assert.notNull(environment, "Environment must not be null!");
        this.metadataReaderFactory = metadataReaderFactory;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }

    public AbstractBeanDefinition detectCustomImplementation(String className, Iterable<String> basePackages) {
        Assert.notNull(className, "ClassName must not be null!");
        Assert.notNull(basePackages, "BasePackages must not be null!");
        Pattern pattern = Pattern.compile(".*\\." + className);
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setEnvironment(this.environment);
        provider.setResourceLoader(this.resourceLoader);
        provider.setResourcePattern(String.format(CUSTOM_IMPLEMENTATION_RESOURCE_PATTERN, className));
        provider.setMetadataReaderFactory(this.metadataReaderFactory);
        provider.addIncludeFilter(new RegexPatternTypeFilter(pattern));
        HashSet<BeanDefinition> definitions = new HashSet<BeanDefinition>();
        for (String basePackage : basePackages) {
            definitions.addAll(provider.findCandidateComponents(basePackage));
        }
        if (definitions.isEmpty()) {
            return null;
        }
        if (definitions.size() == 1) {
            return (AbstractBeanDefinition)definitions.iterator().next();
        }
        ArrayList<String> implementationClassNames = new ArrayList<String>();
        for (BeanDefinition bean : definitions) {
            implementationClassNames.add(bean.getBeanClassName());
        }
        throw new IllegalStateException(String.format("Ambiguous custom implementations detected! Found %s but expected a single implementation!", StringUtils.collectionToCommaDelimitedString(implementationClassNames)));
    }
}

