/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.QueryArgProfile;
import com.amazonaws.services.cloudfront.model.QueryArgProfiles;
import com.amazonaws.services.cloudfront.model.transform.QueryArgProfileStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class QueryArgProfilesStaxUnmarshaller
implements Unmarshaller<QueryArgProfiles, StaxUnmarshallerContext> {
    private static QueryArgProfilesStaxUnmarshaller instance;

    @Override
    public QueryArgProfiles unmarshall(StaxUnmarshallerContext context) throws Exception {
        QueryArgProfiles queryArgProfiles = new QueryArgProfiles();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return queryArgProfiles;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    queryArgProfiles.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    queryArgProfiles.withItems(new ArrayList<QueryArgProfile>());
                    continue;
                }
                if (!context.testExpression("Items/QueryArgProfile", targetDepth)) continue;
                queryArgProfiles.withItems(QueryArgProfileStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return queryArgProfiles;
    }

    public static QueryArgProfilesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new QueryArgProfilesStaxUnmarshaller();
        }
        return instance;
    }
}

