/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.s3.AmazonS3;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storage.StringDataStoreFactory;
import org.duracloud.s3task.NoopTaskRunner;
import org.duracloud.s3task.storage.SetStoragePolicyTaskRunner;
import org.duracloud.s3task.streaminghls.DeleteHlsTaskRunner;
import org.duracloud.s3task.streaminghls.DisableHlsTaskRunner;
import org.duracloud.s3task.streaminghls.EnableHlsTaskRunner;
import org.duracloud.s3task.streaminghls.GetHlsSignedCookiesUrlTaskRunner;
import org.duracloud.s3task.streaminghls.GetUrlHlsTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskProviderBase;
import org.slf4j.LoggerFactory;

public class S3TaskProvider
extends TaskProviderBase {
    public S3TaskProvider(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3 s3Client, AmazonCloudFrontClient cfClient, StringDataStoreFactory dataStoreFactory, String cfAccountId, String cfKeyId, String cfKeyPath, String storeId, String dcHost) {
        super(storeId);
        this.log = LoggerFactory.getLogger(S3TaskProvider.class);
        this.taskList.add(new NoopTaskRunner());
        this.taskList.add(new SetStoragePolicyTaskRunner(unwrappedS3Provider));
        this.taskList.add(new EnableHlsTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfClient, cfAccountId, dcHost));
        this.taskList.add(new GetUrlHlsTaskRunner(s3Provider, unwrappedS3Provider, cfClient));
        this.taskList.add(new GetHlsSignedCookiesUrlTaskRunner(s3Provider, unwrappedS3Provider, cfClient, dataStoreFactory, cfKeyId, cfKeyPath));
        this.taskList.add(new DisableHlsTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfClient));
        this.taskList.add(new DeleteHlsTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfClient));
    }
}

