/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javaslang.collection.Seq;
import javaslang.collection.Traversable;
import lombok.Generated;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Slice;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.repository.util.JavaslangCollections;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.data.repository.util.VavrCollections;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import scala.Function0;
import scala.Option;
import scala.runtime.AbstractFunction0;

public abstract class QueryExecutionConverters {
    private static final boolean GUAVA_PRESENT = ClassUtils.isPresent("com.google.common.base.Optional", QueryExecutionConverters.class.getClassLoader());
    private static final boolean JDK_8_PRESENT = ClassUtils.isPresent("java.util.Optional", QueryExecutionConverters.class.getClassLoader());
    private static final boolean SCALA_PRESENT = ClassUtils.isPresent("scala.Option", QueryExecutionConverters.class.getClassLoader());
    private static final boolean JAVASLANG_PRESENT = ClassUtils.isPresent("javaslang.control.Option", QueryExecutionConverters.class.getClassLoader());
    private static final boolean VAVR_PRESENT = ClassUtils.isPresent("io.vavr.control.Option", QueryExecutionConverters.class.getClassLoader());
    private static final Set<WrapperType> WRAPPER_TYPES = new HashSet<WrapperType>();
    private static final Set<Converter<Object, Object>> UNWRAPPERS = new HashSet<Converter<Object, Object>>();
    private static final Set<Class<?>> ALLOWED_PAGEABLE_TYPES = new HashSet();

    private QueryExecutionConverters() {
    }

    public static boolean supports(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        for (WrapperType candidate : WRAPPER_TYPES) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSingleValue(Class<?> type) {
        for (WrapperType candidate : WRAPPER_TYPES) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            return candidate.isSingleValue();
        }
        return false;
    }

    public static Set<Class<?>> getAllowedPageableTypes() {
        return Collections.unmodifiableSet(ALLOWED_PAGEABLE_TYPES);
    }

    public static void registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull(conversionService, "ConversionService must not be null!");
        conversionService.removeConvertible(Collection.class, Object.class);
        if (GUAVA_PRESENT) {
            conversionService.addConverter(new NullableWrapperToGuavaOptionalConverter(conversionService));
        }
        if (JDK_8_PRESENT) {
            conversionService.addConverter(new NullableWrapperToJdk8OptionalConverter(conversionService));
            conversionService.addConverter(new NullableWrapperToCompletableFutureConverter(conversionService));
        }
        if (SCALA_PRESENT) {
            conversionService.addConverter(new NullableWrapperToScalaOptionConverter(conversionService));
        }
        if (JAVASLANG_PRESENT) {
            conversionService.addConverter(new NullableWrapperToJavaslangOptionConverter(conversionService));
            conversionService.addConverter(JavaslangCollections.FromJavaConverter.INSTANCE);
        }
        if (VAVR_PRESENT) {
            conversionService.addConverter(new NullableWrapperToVavrOptionConverter(conversionService));
            conversionService.addConverter(VavrCollections.FromJavaConverter.INSTANCE);
        }
        conversionService.addConverter(new NullableWrapperToFutureConverter(conversionService));
    }

    public static Object unwrap(Object source) {
        if (source == null || !QueryExecutionConverters.supports(source.getClass())) {
            return source;
        }
        for (Converter<Object, Object> converter : UNWRAPPERS) {
            Object result = converter.convert(source);
            if (result == source) continue;
            return result;
        }
        return source;
    }

    public static TypeInformation<?> unwrapWrapperTypes(TypeInformation<?> type) {
        Assert.notNull(type, "type must not be null");
        Class<?> rawType = type.getType();
        boolean needToUnwrap = type.isCollectionLike() || Slice.class.isAssignableFrom(rawType) || GeoResults.class.isAssignableFrom(rawType) || rawType.isArray() || QueryExecutionConverters.supports(rawType) || ReflectionUtils.isJava8StreamType(rawType);
        return needToUnwrap ? QueryExecutionConverters.unwrapWrapperTypes(type.getComponentType()) : type;
    }

    static {
        WRAPPER_TYPES.add(WrapperType.singleValue(Future.class));
        WRAPPER_TYPES.add(WrapperType.singleValue(ListenableFuture.class));
        ALLOWED_PAGEABLE_TYPES.add(Slice.class);
        ALLOWED_PAGEABLE_TYPES.add(Page.class);
        ALLOWED_PAGEABLE_TYPES.add(List.class);
        if (GUAVA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToGuavaOptionalConverter.getWrapperType());
            UNWRAPPERS.add(GuavaOptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToJdk8OptionalConverter.getWrapperType());
            UNWRAPPERS.add(Jdk8OptionalUnwrapper.INSTANCE);
        }
        if (JDK_8_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToCompletableFutureConverter.getWrapperType());
        }
        if (SCALA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToScalaOptionConverter.getWrapperType());
            UNWRAPPERS.add(ScalOptionUnwrapper.INSTANCE);
        }
        if (JAVASLANG_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToJavaslangOptionConverter.getWrapperType());
            WRAPPER_TYPES.add(JavaslangCollections.ToJavaConverter.INSTANCE.getWrapperType());
            UNWRAPPERS.add(JavaslangOptionUnwrapper.INSTANCE);
            ALLOWED_PAGEABLE_TYPES.add(Seq.class);
        }
        if (VAVR_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToVavrOptionConverter.getWrapperType());
            WRAPPER_TYPES.add(VavrCollections.ToJavaConverter.INSTANCE.getWrapperType());
            UNWRAPPERS.add(VavrOptionUnwrapper.INSTANCE);
            ALLOWED_PAGEABLE_TYPES.add(io.vavr.collection.Seq.class);
        }
    }

    public static final class WrapperType {
        private final Class<?> type;
        private final boolean singleValue;

        public static WrapperType singleValue(Class<?> type) {
            return new WrapperType(type, true);
        }

        public static WrapperType multiValue(Class<?> type) {
            return new WrapperType(type, false);
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public boolean isSingleValue() {
            return this.singleValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrapperType)) {
                return false;
            }
            WrapperType other = (WrapperType)o;
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            return this.isSingleValue() == other.isSingleValue();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + (this.isSingleValue() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "QueryExecutionConverters.WrapperType(type=" + this.getType() + ", singleValue=" + this.isSingleValue() + ")";
        }

        @Generated
        private WrapperType(Class<?> type, boolean singleValue) {
            this.type = type;
            this.singleValue = singleValue;
        }
    }

    private static enum VavrOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;

        private static final Supplier<Object> NULL_SUPPLIER;

        @Override
        public Object convert(Object source) {
            if (source instanceof io.vavr.control.Option) {
                return ((io.vavr.control.Option)source).getOrElse(NULL_SUPPLIER);
            }
            if (source instanceof io.vavr.collection.Traversable) {
                return VavrCollections.ToJavaConverter.INSTANCE.convert(source);
            }
            return source;
        }

        static {
            NULL_SUPPLIER = new Supplier<Object>(){

                @Override
                public Object get() {
                    return null;
                }
            };
        }
    }

    private static enum JavaslangOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;

        private static final Supplier<Object> NULL_SUPPLIER;

        @Override
        public Object convert(Object source) {
            if (source instanceof javaslang.control.Option) {
                return ((javaslang.control.Option)source).getOrElse(NULL_SUPPLIER);
            }
            if (source instanceof Traversable) {
                return JavaslangCollections.ToJavaConverter.INSTANCE.convert(source);
            }
            return source;
        }

        static {
            NULL_SUPPLIER = new Supplier<Object>(){

                @Override
                public Object get() {
                    return null;
                }
            };
        }
    }

    private static enum ScalOptionUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;

        private final Function0<Object> alternative = new AbstractFunction0<Object>(){

            public Option<Object> apply() {
                return null;
            }
        };

        @Override
        public Object convert(Object source) {
            return source instanceof Option ? ((Option)source).getOrElse(this.alternative) : source;
        }
    }

    private static enum Jdk8OptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source) {
            return source instanceof Optional ? ((Optional)source).orElse(null) : source;
        }
    }

    private static enum GuavaOptionalUnwrapper implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source) {
            return source instanceof com.google.common.base.Optional ? ((com.google.common.base.Optional)source).orNull() : source;
        }
    }

    private static class NullableWrapperToVavrOptionConverter
    extends AbstractWrapperTypeConverter {
        private static final Method OF_METHOD = org.springframework.util.ReflectionUtils.findMethod(io.vavr.control.Option.class, "of", Object.class);
        private static final Method NONE_METHOD = org.springframework.util.ReflectionUtils.findMethod(io.vavr.control.Option.class, "none");

        public NullableWrapperToVavrOptionConverter(ConversionService conversionService) {
            super(conversionService, NullableWrapperToVavrOptionConverter.createEmptyOption(), io.vavr.control.Option.class);
        }

        @Override
        protected Object wrap(Object source) {
            return org.springframework.util.ReflectionUtils.invokeMethod(OF_METHOD, null, source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(io.vavr.control.Option.class);
        }

        private static io.vavr.control.Option<Object> createEmptyOption() {
            return (io.vavr.control.Option)org.springframework.util.ReflectionUtils.invokeMethod(NONE_METHOD, null);
        }
    }

    private static class NullableWrapperToJavaslangOptionConverter
    extends AbstractWrapperTypeConverter {
        private static final Method OF_METHOD = org.springframework.util.ReflectionUtils.findMethod(javaslang.control.Option.class, "of", Object.class);
        private static final Method NONE_METHOD = org.springframework.util.ReflectionUtils.findMethod(javaslang.control.Option.class, "none");

        public NullableWrapperToJavaslangOptionConverter(ConversionService conversionService) {
            super(conversionService, NullableWrapperToJavaslangOptionConverter.createEmptyOption(), javaslang.control.Option.class);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(javaslang.control.Option.class);
        }

        @Override
        protected Object wrap(Object source) {
            return org.springframework.util.ReflectionUtils.invokeMethod(OF_METHOD, null, source);
        }

        private static javaslang.control.Option<Object> createEmptyOption() {
            return (javaslang.control.Option)org.springframework.util.ReflectionUtils.invokeMethod(NONE_METHOD, null);
        }
    }

    private static class NullableWrapperToScalaOptionConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToScalaOptionConverter(ConversionService conversionService) {
            super(conversionService, Option.empty(), Option.class);
        }

        @Override
        protected Object wrap(Object source) {
            return Option.apply((Object)source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(Option.class);
        }
    }

    private static class NullableWrapperToCompletableFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToCompletableFutureConverter(ConversionService conversionService) {
            super(conversionService, CompletableFuture.completedFuture(null), CompletableFuture.class);
        }

        @Override
        protected Object wrap(Object source) {
            return source instanceof CompletableFuture ? source : CompletableFuture.completedFuture(source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(CompletableFuture.class);
        }
    }

    private static class NullableWrapperToFutureConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToFutureConverter(ConversionService conversionService) {
            super(conversionService, new AsyncResult<Object>(null), Future.class, ListenableFuture.class);
        }

        @Override
        protected Object wrap(Object source) {
            return new AsyncResult<Object>(source);
        }
    }

    private static class NullableWrapperToJdk8OptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToJdk8OptionalConverter(ConversionService conversionService) {
            super(conversionService, Optional.empty(), Optional.class);
        }

        @Override
        protected Object wrap(Object source) {
            return Optional.of(source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(Optional.class);
        }
    }

    private static class NullableWrapperToGuavaOptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToGuavaOptionalConverter(ConversionService conversionService) {
            super(conversionService, com.google.common.base.Optional.absent(), com.google.common.base.Optional.class);
        }

        @Override
        protected Object wrap(Object source) {
            return com.google.common.base.Optional.of((Object)source);
        }

        public static WrapperType getWrapperType() {
            return WrapperType.singleValue(com.google.common.base.Optional.class);
        }
    }

    private static abstract class AbstractWrapperTypeConverter
    implements GenericConverter {
        private final ConversionService conversionService;
        private final Class<?>[] wrapperTypes;
        private final Object nullValue;

        protected AbstractWrapperTypeConverter(ConversionService conversionService, Object nullValue, Class<?> ... wrapperTypes) {
            Assert.notNull(conversionService, "ConversionService must not be null!");
            Assert.notEmpty(wrapperTypes, "Wrapper type must not be empty!");
            this.conversionService = conversionService;
            this.wrapperTypes = wrapperTypes;
            this.nullValue = nullValue;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>(this.wrapperTypes.length);
            for (Class<?> wrapperType : this.wrapperTypes) {
                pairs.add(new GenericConverter.ConvertiblePair(NullableWrapper.class, wrapperType));
            }
            return Collections.unmodifiableSet(pairs);
        }

        @Override
        public final Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            NullableWrapper wrapper = (NullableWrapper)source;
            Object value = wrapper.getValue();
            return value == null ? this.nullValue : this.wrap(value);
        }

        protected abstract Object wrap(Object var1);
    }
}

