/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.Tag;
import com.amazonaws.services.cloudfront.model.TagResourceRequest;
import com.amazonaws.services.cloudfront.model.Tags;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class TagResourceRequestMarshaller
implements Marshaller<Request<TagResourceRequest>, TagResourceRequest> {
    @Override
    public Request<TagResourceRequest> marshall(TagResourceRequest tagResourceRequest) {
        if (tagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TagResourceRequest> request = new DefaultRequest<TagResourceRequest>(tagResourceRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/tagging?Operation=Tag";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (tagResourceRequest.getResource() != null) {
            request.addParameter("Resource", StringUtils.fromString(tagResourceRequest.getResource()));
        }
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            Tags tags = tagResourceRequest.getTags();
            if (tags != null) {
                xmlWriter.startElement("Tags");
                SdkInternalList tagsItemsList = (SdkInternalList)tags.getItems();
                if (!tagsItemsList.isEmpty() || !tagsItemsList.isAutoConstruct()) {
                    xmlWriter.startElement("Items");
                    for (Tag tagsItemsListValue : tagsItemsList) {
                        xmlWriter.startElement("Tag");
                        if (tagsItemsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(tagsItemsListValue.getKey()).endElement();
                        }
                        if (tagsItemsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(tagsItemsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

