/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers.frameoptions;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.header.writers.frameoptions.AllowFromStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractRequestParameterAllowFromStrategy
implements AllowFromStrategy {
    private static final String DEFAULT_ORIGIN_REQUEST_PARAMETER = "x-frames-allow-from";
    private String allowFromParameterName = "x-frames-allow-from";
    protected final Log log = LogFactory.getLog(this.getClass());

    AbstractRequestParameterAllowFromStrategy() {
    }

    @Override
    public String getAllowFromValue(HttpServletRequest request) {
        String allowFromOrigin = request.getParameter(this.allowFromParameterName);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Supplied origin '" + allowFromOrigin + "'");
        }
        if (StringUtils.hasText(allowFromOrigin) && this.allowed(allowFromOrigin)) {
            return allowFromOrigin;
        }
        return "DENY";
    }

    public void setAllowFromParameterName(String allowFromParameterName) {
        Assert.notNull(allowFromParameterName, "allowFromParameterName cannot be null");
        this.allowFromParameterName = allowFromParameterName;
    }

    protected abstract boolean allowed(String var1);
}

