/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.KeyGroupList;
import com.amazonaws.services.cloudfront.model.KeyGroupSummary;
import com.amazonaws.services.cloudfront.model.transform.KeyGroupSummaryStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class KeyGroupListStaxUnmarshaller
implements Unmarshaller<KeyGroupList, StaxUnmarshallerContext> {
    private static KeyGroupListStaxUnmarshaller instance;

    @Override
    public KeyGroupList unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyGroupList keyGroupList = new KeyGroupList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyGroupList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NextMarker", targetDepth)) {
                    keyGroupList.setNextMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    keyGroupList.setMaxItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    keyGroupList.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    keyGroupList.withItems(new ArrayList<KeyGroupSummary>());
                    continue;
                }
                if (!context.testExpression("Items/KeyGroupSummary", targetDepth)) continue;
                keyGroupList.withItems(KeyGroupSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyGroupList;
    }

    public static KeyGroupListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyGroupListStaxUnmarshaller();
        }
        return instance;
    }
}

