/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIdentityPoliciesRequestMarshaller
implements Marshaller<Request<GetIdentityPoliciesRequest>, GetIdentityPoliciesRequest> {
    @Override
    public Request<GetIdentityPoliciesRequest> marshall(GetIdentityPoliciesRequest getIdentityPoliciesRequest) {
        if (getIdentityPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetIdentityPoliciesRequest> request = new DefaultRequest<GetIdentityPoliciesRequest>(getIdentityPoliciesRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "GetIdentityPolicies");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityPoliciesRequest.getIdentity() != null) {
            request.addParameter("Identity", StringUtils.fromString(getIdentityPoliciesRequest.getIdentity()));
        }
        if (!getIdentityPoliciesRequest.getPolicyNames().isEmpty() || !((SdkInternalList)getIdentityPoliciesRequest.getPolicyNames()).isAutoConstruct()) {
            SdkInternalList policyNamesList = (SdkInternalList)getIdentityPoliciesRequest.getPolicyNames();
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString(policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        return request;
    }
}

