/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Frequency {
    private String timeUnit;
    private int value;
    private static Map<String, Integer> timeUnitToCalendarMap = new HashMap<String, Integer>();

    public Frequency(String frequency) throws ParseException {
        this.parse(frequency);
    }

    private void parse(String frequency) throws ParseException {
        Pattern p = Pattern.compile("([0]|[1-9][0-9]*)([sMhdm])");
        Matcher m = p.matcher(frequency);
        if (!m.matches()) {
            throw new ParseException(frequency + " is not a valid frequency", 0);
        }
        this.value = Integer.parseInt(m.group(1));
        this.timeUnit = m.group(2);
    }

    public int getValue() {
        return this.value;
    }

    public int getTimeUnit() {
        return timeUnitToCalendarMap.get(this.timeUnit);
    }

    public String getTimeUnitAsString() {
        return this.timeUnit;
    }

    public String toString() {
        return this.getValue() + this.timeUnit;
    }

    static {
        timeUnitToCalendarMap.put("s", 13);
        timeUnitToCalendarMap.put("M", 12);
        timeUnitToCalendarMap.put("h", 10);
        timeUnitToCalendarMap.put("d", 5);
        timeUnitToCalendarMap.put("m", 2);
    }
}

