/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3storage;

import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.StorageClass;

public class StoragePolicy {
    private StorageClass storageClass;
    private int daysToTransition;

    public StoragePolicy(StorageClass storageClass, int daysToTransition) {
        this.storageClass = storageClass;
        this.daysToTransition = daysToTransition;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public int getDaysToTransition() {
        return this.daysToTransition;
    }

    public BucketLifecycleConfiguration getBucketLifecycleConfig() {
        BucketLifecycleConfiguration.Transition transition = new BucketLifecycleConfiguration.Transition().withDays(this.daysToTransition).withStorageClass(this.storageClass);
        String policyName = "Transition to " + this.storageClass.name() + " in " + this.daysToTransition + " days";
        BucketLifecycleConfiguration.Rule rule = new BucketLifecycleConfiguration.Rule().withId(policyName).withPrefix("").withStatus("Enabled".toString());
        rule.addTransition(transition);
        return new BucketLifecycleConfiguration().withRules(rule);
    }
}

