/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.impl;

import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class DuracloudAuthProvider
extends DaoAuthenticationProvider {
    private final Logger log = LoggerFactory.getLogger(DuracloudAuthProvider.class);

    public DuracloudAuthProvider(DuracloudUserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        super.setUserDetailsService(userDetailsService);
        super.setPasswordEncoder(passwordEncoder);
    }

    @Override
    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        DuracloudUserDetails dcUserDetails = (DuracloudUserDetails)userDetails;
        String userIpLimits = dcUserDetails.getIpLimits();
        if (null != userIpLimits && !userIpLimits.equals("")) {
            String[] ipLimits;
            WebAuthenticationDetails details = (WebAuthenticationDetails)authentication.getDetails();
            String requestIp = details.getRemoteAddress();
            for (String ipLimit : ipLimits = userIpLimits.split(";")) {
                if (!this.ipInRange(requestIp, ipLimit)) continue;
                this.log.debug("Allowing authentication check to continue for user " + dcUserDetails.getUsername() + " because their IP " + requestIp + " exists in a valid range " + ipLimit);
                return;
            }
            this.log.debug("Denying authentication request for user " + dcUserDetails.getUsername() + " because their IP " + requestIp + " does not match any valid ranges " + userIpLimits);
            throw new InsufficientAuthenticationException("Originating IP for authentication request" + requestIp + " is not in an accepted range.");
        }
        this.log.debug("Allowing authentication check to continue for user " + dcUserDetails.getUsername() + " because no IP limits are defined");
    }

    protected boolean ipInRange(String ipAddress, String range) {
        IpAddressMatcher addressMatcher = new IpAddressMatcher(range);
        return addressMatcher.matches(ipAddress);
    }
}

