/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.task.GetSnapshotContentsTaskParameters;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.snapshottask.snapshot.GetSnapshotsTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSnapshotContentsTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(GetSnapshotsTaskRunner.class);

    public GetSnapshotContentsTaskRunner(String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
    }

    @Override
    public String getName() {
        return "get-snapshot-contents";
    }

    @Override
    public String performTask(String taskParameters) {
        GetSnapshotContentsTaskParameters taskParams = GetSnapshotContentsTaskParameters.deserialize(taskParameters);
        return this.callBridge(this.createRestHelper(), this.buildBridgeURL(taskParams));
    }

    protected String buildBridgeURL(GetSnapshotContentsTaskParameters taskParams) {
        int pageSize;
        int pageNumber = taskParams.getPageNumber();
        if (pageNumber < 0) {
            pageNumber = 0;
        }
        if ((pageSize = taskParams.getPageSize()) < 1 || pageSize > 1000) {
            pageSize = 1000;
        }
        String snapshotId = taskParams.getSnapshotId();
        String prefix = taskParams.getPrefix();
        String prefixParam = "&prefix=" + (prefix != null ? prefix : "");
        return MessageFormat.format("{0}/snapshot/{1}/content?page={2}&pageSize={3}{4}", this.buildBridgeBaseURL(), snapshotId, String.valueOf(pageNumber), String.valueOf(pageSize), prefixParam);
    }

    protected String callBridge(RestHttpHelper restHelper, String bridgeURL) {
        this.log.info("Making bridge call to get snapshot contents. URL: {}", (Object)bridgeURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.get(bridgeURL);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to get snapshot contents. Error reported: " + e.getMessage(), e);
        }
    }
}

