/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.task.GetSnapshotsTotalsTaskParameters;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSnapshotsTotalsTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(GetSnapshotsTotalsTaskRunner.class);
    private String dcHost;
    private String dcStoreId;
    private StorageProvider storageProvider;

    public GetSnapshotsTotalsTaskRunner(String dcHost, String dcStoreId, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass, StorageProvider storageProvider) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.dcHost = dcHost;
        this.dcStoreId = dcStoreId;
        this.storageProvider = storageProvider;
    }

    @Override
    public String getName() {
        return "get-snapshots-totals";
    }

    @Override
    public String performTask(String taskParameters) {
        GetSnapshotsTotalsTaskParameters taskParams = GetSnapshotsTotalsTaskParameters.deserialize(taskParameters);
        String result = this.callBridge(this.createRestHelper(), this.buildBridgeURL(taskParams));
        return result;
    }

    protected String buildBridgeURL(GetSnapshotsTotalsTaskParameters taskParams) {
        String status = taskParams.getStatus();
        return MessageFormat.format("{0}/snapshot/total?host={1}&storeId={2}&status={3}", this.buildBridgeBaseURL(), this.dcHost, this.dcStoreId, status);
    }

    protected String callBridge(RestHttpHelper restHelper, String bridgeURL) {
        this.log.info("Making bridge call to get total count, size, and files of snapshots. URL: {}", (Object)bridgeURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.get(bridgeURL);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to get total count, size, and files of snapshots. Error reported: " + e.getMessage(), e);
        }
    }
}

