/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

final class SupplierDeferredSecurityContext
implements DeferredSecurityContext {
    private static final Log logger = LogFactory.getLog(SupplierDeferredSecurityContext.class);
    private final Supplier<SecurityContext> supplier;
    private final SecurityContextHolderStrategy strategy;
    private SecurityContext securityContext;
    private boolean missingContext;

    SupplierDeferredSecurityContext(Supplier<SecurityContext> supplier, SecurityContextHolderStrategy strategy) {
        this.supplier = supplier;
        this.strategy = strategy;
    }

    @Override
    public SecurityContext get() {
        this.init();
        return this.securityContext;
    }

    @Override
    public boolean isGenerated() {
        this.init();
        return this.missingContext;
    }

    private void init() {
        if (this.securityContext != null) {
            return;
        }
        this.securityContext = this.supplier.get();
        boolean bl = this.missingContext = this.securityContext == null;
        if (this.missingContext) {
            this.securityContext = this.strategy.createEmptyContext();
            if (logger.isTraceEnabled()) {
                logger.trace(LogMessage.format("Created %s", (Object)this.securityContext));
            }
        }
    }
}

