/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CreateFunctionRequest;
import com.amazonaws.services.cloudfront.model.FunctionConfig;
import com.amazonaws.services.cloudfront.model.KeyValueStoreAssociation;
import com.amazonaws.services.cloudfront.model.KeyValueStoreAssociations;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateFunctionRequestMarshaller
implements Marshaller<Request<CreateFunctionRequest>, CreateFunctionRequest> {
    @Override
    public Request<CreateFunctionRequest> marshall(CreateFunctionRequest createFunctionRequest) {
        if (createFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFunctionRequest> request = new DefaultRequest<CreateFunctionRequest>(createFunctionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/function";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("CreateFunctionRequest");
            if (createFunctionRequest != null) {
                FunctionConfig functionConfig;
                if (createFunctionRequest.getName() != null) {
                    xmlWriter.startElement("Name").value(createFunctionRequest.getName()).endElement();
                }
                if ((functionConfig = createFunctionRequest.getFunctionConfig()) != null) {
                    KeyValueStoreAssociations keyValueStoreAssociations;
                    xmlWriter.startElement("FunctionConfig");
                    if (functionConfig.getComment() != null) {
                        xmlWriter.startElement("Comment").value(functionConfig.getComment()).endElement();
                    }
                    if (functionConfig.getRuntime() != null) {
                        xmlWriter.startElement("Runtime").value(functionConfig.getRuntime()).endElement();
                    }
                    if ((keyValueStoreAssociations = functionConfig.getKeyValueStoreAssociations()) != null) {
                        SdkInternalList keyValueStoreAssociationsItemsList;
                        xmlWriter.startElement("KeyValueStoreAssociations");
                        if (keyValueStoreAssociations.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(keyValueStoreAssociations.getQuantity()).endElement();
                        }
                        if (!(keyValueStoreAssociationsItemsList = (SdkInternalList)keyValueStoreAssociations.getItems()).isEmpty() || !keyValueStoreAssociationsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (KeyValueStoreAssociation keyValueStoreAssociationsItemsListValue : keyValueStoreAssociationsItemsList) {
                                xmlWriter.startElement("KeyValueStoreAssociation");
                                if (keyValueStoreAssociationsItemsListValue.getKeyValueStoreARN() != null) {
                                    xmlWriter.startElement("KeyValueStoreARN").value(keyValueStoreAssociationsItemsListValue.getKeyValueStoreARN()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createFunctionRequest.getFunctionCode() != null) {
                    xmlWriter.startElement("FunctionCode").value(createFunctionRequest.getFunctionCode()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

