/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CreateMonitoringSubscriptionRequest;
import com.amazonaws.services.cloudfront.model.MonitoringSubscription;
import com.amazonaws.services.cloudfront.model.RealtimeMetricsSubscriptionConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateMonitoringSubscriptionRequestMarshaller
implements Marshaller<Request<CreateMonitoringSubscriptionRequest>, CreateMonitoringSubscriptionRequest> {
    @Override
    public Request<CreateMonitoringSubscriptionRequest> marshall(CreateMonitoringSubscriptionRequest createMonitoringSubscriptionRequest) {
        if (createMonitoringSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateMonitoringSubscriptionRequest> request = new DefaultRequest<CreateMonitoringSubscriptionRequest>(createMonitoringSubscriptionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/distributions/{DistributionId}/monitoring-subscription/";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DistributionId", createMonitoringSubscriptionRequest.getDistributionId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            MonitoringSubscription monitoringSubscription = createMonitoringSubscriptionRequest.getMonitoringSubscription();
            if (monitoringSubscription != null) {
                xmlWriter.startElement("MonitoringSubscription");
                RealtimeMetricsSubscriptionConfig realtimeMetricsSubscriptionConfig = monitoringSubscription.getRealtimeMetricsSubscriptionConfig();
                if (realtimeMetricsSubscriptionConfig != null) {
                    xmlWriter.startElement("RealtimeMetricsSubscriptionConfig");
                    if (realtimeMetricsSubscriptionConfig.getRealtimeMetricsSubscriptionStatus() != null) {
                        xmlWriter.startElement("RealtimeMetricsSubscriptionStatus").value(realtimeMetricsSubscriptionConfig.getRealtimeMetricsSubscriptionStatus()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

