/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.TrustedKeyGroups;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class TrustedKeyGroupsStaxUnmarshaller
implements Unmarshaller<TrustedKeyGroups, StaxUnmarshallerContext> {
    private static TrustedKeyGroupsStaxUnmarshaller instance;

    @Override
    public TrustedKeyGroups unmarshall(StaxUnmarshallerContext context) throws Exception {
        TrustedKeyGroups trustedKeyGroups = new TrustedKeyGroups();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return trustedKeyGroups;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    trustedKeyGroups.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    trustedKeyGroups.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    trustedKeyGroups.withItems(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/KeyGroup", targetDepth)) continue;
                trustedKeyGroups.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return trustedKeyGroups;
    }

    public static TrustedKeyGroupsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TrustedKeyGroupsStaxUnmarshaller();
        }
        return instance;
    }
}

