/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Chunk;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public class PageImpl<T>
extends Chunk<T>
implements Page<T> {
    private static final long serialVersionUID = 867755909294344406L;
    private final long total;
    private final Pageable pageable;

    public PageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable);
        Assert.isTrue(total >= (long)content.size(), "Total must not be less than the number of elements given!");
        this.total = total;
        this.pageable = pageable;
    }

    public PageImpl(List<T> content) {
        this(content, null, null == content ? 0L : (long)content.size());
    }

    @Override
    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    @Override
    public long getTotalElements() {
        return this.total;
    }

    @Override
    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    @Override
    public boolean isLast() {
        return !this.hasNext();
    }

    @Override
    public <S> Page<S> map(Converter<? super T, ? extends S> converter) {
        return new PageImpl<S>(this.getConvertedContent(converter), this.pageable, this.total);
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List content = this.getContent();
        if (content.size() > 0) {
            contentType = content.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber(), this.getTotalPages(), contentType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageImpl)) {
            return false;
        }
        PageImpl that = (PageImpl)obj;
        return this.total == that.total && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result += 31 * (int)(this.total ^ this.total >>> 32);
        return result += 31 * super.hashCode();
    }
}

