/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.AccessType;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AbstractPersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

public abstract class AnnotationBasedPersistentProperty<P extends PersistentProperty<P>>
extends AbstractPersistentProperty<P> {
    private static final String SPRING_DATA_PACKAGE = "org.springframework.data";
    private final Value value;
    private final Map<Class<? extends Annotation>, Annotation> annotationCache = new HashMap<Class<? extends Annotation>, Annotation>();
    private Boolean isTransient;
    private boolean usePropertyAccess;

    public AnnotationBasedPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        this.populateAnnotationCache(field);
        AccessType accessType = this.findPropertyOrOwnerAnnotation(AccessType.class);
        this.usePropertyAccess = accessType == null ? false : AccessType.Type.PROPERTY.equals((Object)accessType.value());
        this.value = this.findAnnotation(Value.class);
    }

    private final void populateAnnotationCache(Field field) {
        for (Method method : Arrays.asList(this.getGetter(), this.getSetter())) {
            if (method == null) continue;
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                this.validateAnnotation(annotation, "Ambiguous mapping! Annotation %s configured multiple times on accessor methods of property %s in class %s!", annotationType.getSimpleName(), this.getName(), this.getOwner().getType().getSimpleName());
                this.annotationCache.put(annotationType, annotation);
            }
        }
        if (field == null) {
            return;
        }
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            this.validateAnnotation(annotation, "Ambiguous mapping! Annotation %s configured on field %s and one of its accessor methods in class %s!", annotationType.getSimpleName(), field.getName(), this.getOwner().getType().getSimpleName());
            this.annotationCache.put(annotationType, annotation);
        }
    }

    private void validateAnnotation(Annotation candidate, String message, Object ... arguments) {
        Class<? extends Annotation> annotationType = candidate.annotationType();
        if (!annotationType.getName().startsWith(SPRING_DATA_PACKAGE)) {
            return;
        }
        if (this.annotationCache.containsKey(annotationType) && !this.annotationCache.get(annotationType).equals(candidate)) {
            throw new MappingException(String.format(message, arguments));
        }
    }

    @Override
    public String getSpelExpression() {
        return this.value == null ? null : this.value.value();
    }

    @Override
    public boolean isTransient() {
        if (this.isTransient == null) {
            boolean potentiallyTransient = super.isTransient() || this.isAnnotationPresent(Transient.class);
            this.isTransient = potentiallyTransient || this.isAnnotationPresent(Value.class) || this.isAnnotationPresent(Autowired.class);
        }
        return this.isTransient;
    }

    @Override
    public boolean isIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    @Override
    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    @Override
    public boolean isAssociation() {
        return !this.isTransient() && this.isAnnotationPresent(Reference.class);
    }

    @Override
    public boolean isWritable() {
        return !this.isTransient() && !this.isAnnotationPresent(ReadOnlyProperty.class);
    }

    @Override
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        Assert.notNull(annotationType, "Annotation type must not be null!");
        if (this.annotationCache != null && this.annotationCache.containsKey(annotationType)) {
            return (A)this.annotationCache.get(annotationType);
        }
        for (Method method : Arrays.asList(this.getGetter(), this.getSetter())) {
            A annotation;
            if (method == null || (annotation = AnnotationUtils.findAnnotation(method, annotationType)) == null) continue;
            return this.cacheAndReturn((Class<? extends A>)annotationType, annotation);
        }
        return this.field == null ? null : (A)this.cacheAndReturn((Class<? extends A>)annotationType, AnnotationUtils.getAnnotation(this.field, annotationType));
    }

    @Override
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        A annotation = this.findAnnotation(annotationType);
        return annotation == null ? this.owner.findAnnotation(annotationType) : annotation;
    }

    private <A extends Annotation> A cacheAndReturn(Class<? extends A> type, A annotation) {
        if (this.annotationCache != null) {
            this.annotationCache.put(type, annotation);
        }
        return annotation;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.findAnnotation(annotationType) != null;
    }

    @Override
    public boolean usePropertyAccess() {
        return super.usePropertyAccess() || this.usePropertyAccess;
    }

    @Override
    public String toString() {
        if (this.annotationCache.isEmpty()) {
            this.populateAnnotationCache(this.field);
        }
        StringBuilder builder = new StringBuilder();
        for (Annotation annotation : this.annotationCache.values()) {
            if (annotation == null) continue;
            builder.append(annotation.toString()).append(" ");
        }
        return builder.toString() + super.toString();
    }
}

