/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl;

import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class QSort
extends Sort
implements Serializable {
    private static final long serialVersionUID = -6701117396842171930L;
    private final List<OrderSpecifier<?>> orderSpecifiers;

    public QSort(OrderSpecifier<?> ... orderSpecifiers) {
        this(Arrays.asList(orderSpecifiers));
    }

    public QSort(List<OrderSpecifier<?>> orderSpecifiers) {
        super(QSort.toOrders(orderSpecifiers));
        Assert.notEmpty(orderSpecifiers, "Order specifiers must not be null or empty!");
        this.orderSpecifiers = orderSpecifiers;
    }

    private static List<Sort.Order> toOrders(List<OrderSpecifier<?>> orderSpecifiers) {
        Assert.notEmpty(orderSpecifiers, "Order specifiers must not be null or empty!");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        for (OrderSpecifier<?> orderSpecifier : orderSpecifiers) {
            orders.add(QSort.toOrder(orderSpecifier));
        }
        return orders;
    }

    private static Sort.Order toOrder(OrderSpecifier<?> orderSpecifier) {
        Assert.notNull(orderSpecifier, "Order specifier must not be null!");
        Expression target = orderSpecifier.getTarget();
        Expression targetElement = target instanceof Path ? QSort.preparePropertyPath((Path)target) : target;
        Assert.notNull(targetElement, "Target element must not be null!");
        return new Sort.Order(targetElement.toString()).with(orderSpecifier.isAscending() ? Sort.Direction.ASC : Sort.Direction.DESC);
    }

    public List<OrderSpecifier<?>> getOrderSpecifiers() {
        return this.orderSpecifiers;
    }

    public QSort and(QSort sort) {
        return sort == null ? this : this.and(sort.getOrderSpecifiers());
    }

    public QSort and(List<OrderSpecifier<?>> orderSpecifiers) {
        Assert.notEmpty(orderSpecifiers, "OrderSpecifiers must not be null or empty!");
        ArrayList newOrderSpecifiers = new ArrayList(this.orderSpecifiers);
        newOrderSpecifiers.addAll(orderSpecifiers);
        return new QSort(newOrderSpecifiers);
    }

    public QSort and(OrderSpecifier<?> ... orderSpecifiers) {
        Assert.notEmpty(orderSpecifiers, "OrderSpecifiers must not be null or empty!");
        return this.and(Arrays.asList(orderSpecifiers));
    }

    private static String preparePropertyPath(Path<?> path) {
        PathMetadata metadata = path.getMetadata();
        Path parent = metadata.getParent();
        if (parent == null) {
            return "";
        }
        String basPath = QSort.preparePropertyPath(parent);
        String element = metadata.getElement().toString();
        return StringUtils.hasText(basPath) ? basPath.concat(".").concat(element) : basPath.concat(element);
    }
}

