/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.util.Closeables2;

public class TransientStorageStrategy
implements LocalStorageStrategy {
    private final ConcurrentMap<String, ConcurrentMap<String, Blob>> containerToBlobs = new ConcurrentHashMap<String, ConcurrentMap<String, Blob>>();
    private final ConcurrentMap<String, Location> containerToLocation = new ConcurrentHashMap<String, Location>();
    private final Supplier<Location> defaultLocation;
    private final DateService dateService;
    private final Blob.Factory blobFactory;
    private final ContentMetadataCodec contentMetadataCodec;

    @Inject
    TransientStorageStrategy(Supplier<Location> defaultLocation, DateService dateService, Blob.Factory blobFactory, ContentMetadataCodec contentMetadataCodec) {
        this.defaultLocation = defaultLocation;
        this.dateService = dateService;
        this.blobFactory = blobFactory;
        this.contentMetadataCodec = contentMetadataCodec;
    }

    @Override
    public boolean containerExists(String containerName) {
        return this.containerToBlobs.containsKey(containerName);
    }

    @Override
    public Iterable<String> getAllContainerNames() {
        return this.containerToBlobs.keySet();
    }

    @Override
    public boolean createContainerInLocation(String containerName, Location location) {
        ConcurrentMap origValue = this.containerToBlobs.putIfAbsent(containerName, new ConcurrentHashMap());
        if (origValue != null) {
            return false;
        }
        this.containerToLocation.put(containerName, location != null ? location : this.defaultLocation.get());
        return true;
    }

    @Override
    public void deleteContainer(String containerName) {
        this.containerToBlobs.remove(containerName);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        ((ConcurrentMap)this.containerToBlobs.get(containerName)).clear();
    }

    @Override
    public boolean blobExists(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        return map != null && map.containsKey(blobName);
    }

    @Override
    public Iterable<String> getBlobKeysInsideContainer(String containerName) {
        return ((ConcurrentMap)this.containerToBlobs.get(containerName)).keySet();
    }

    @Override
    public Blob getBlob(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        return map == null ? null : (Blob)map.get(blobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putBlob(String containerName, Blob blob) throws IOException {
        HashCode actualHashCode;
        byte[] payload;
        HashingInputStream input = new HashingInputStream(Hashing.md5(), blob.getPayload().openStream());
        try {
            payload = ByteStreams.toByteArray(input);
            actualHashCode = input.hash();
            HashCode expectedHashCode = blob.getPayload().getContentMetadata().getContentMD5AsHashCode();
            if (expectedHashCode != null && !actualHashCode.equals(expectedHashCode)) {
                throw new IOException("MD5 hash code mismatch, actual: " + actualHashCode + " expected: " + expectedHashCode);
            }
        }
        finally {
            Closeables2.closeQuietly(input);
        }
        Blob newBlob = this.createUpdatedCopyOfBlobInContainer(containerName, blob, payload, actualHashCode);
        Map map = (Map)this.containerToBlobs.get(containerName);
        map.put(newBlob.getMetadata().getName(), newBlob);
        return BaseEncoding.base16().lowerCase().encode(actualHashCode.asBytes());
    }

    @Override
    public void removeBlob(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        if (map != null) {
            map.remove(blobName);
        }
    }

    @Override
    public Location getLocation(String containerName) {
        return (Location)this.containerToLocation.get(containerName);
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    private Blob createUpdatedCopyOfBlobInContainer(String containerName, Blob in, byte[] input, HashCode contentMd5) {
        Preconditions.checkNotNull(containerName, "containerName");
        Preconditions.checkNotNull(in, "blob");
        Preconditions.checkNotNull(input, "input");
        Preconditions.checkNotNull(contentMd5, "contentMd5");
        ByteSourcePayload payload = Payloads.newByteSourcePayload(ByteSource.wrap(input));
        MutableContentMetadata oldMd = in.getPayload().getContentMetadata();
        HttpUtils.copy(oldMd, payload.getContentMetadata());
        payload.getContentMetadata().setContentMD5(contentMd5);
        Blob blob = this.blobFactory.create(BlobStoreUtils.copy(in.getMetadata()));
        blob.setPayload(payload);
        blob.getMetadata().setContainer(containerName);
        blob.getMetadata().setUri(Uris.uriBuilder(new StringBuilder("mem://").append(containerName)).path(in.getMetadata().getName()).build());
        blob.getMetadata().setLastModified(new Date());
        String eTag = BaseEncoding.base16().lowerCase().encode(contentMd5.asBytes());
        blob.getMetadata().setETag(eTag);
        blob.getAllHeaders().replaceValues("Last-Modified", ImmutableList.of(this.dateService.rfc822DateFormat(blob.getMetadata().getLastModified())));
        blob.getAllHeaders().replaceValues("ETag", ImmutableList.of(eTag));
        this.copyPayloadHeadersToBlob(payload, blob);
        blob.getAllHeaders().putAll(Multimaps.forMap(blob.getMetadata().getUserMetadata()));
        return blob;
    }

    private void copyPayloadHeadersToBlob(Payload payload, Blob blob) {
        blob.getAllHeaders().putAll(this.contentMetadataCodec.toHeaders(payload.getContentMetadata()));
    }
}

