/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.CredentialsRepoException;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.ltp.Frequency;
import org.duracloud.mill.ltp.LoopingTaskProducerConfigurationManager;
import org.duracloud.mill.ltp.Morsel;
import org.duracloud.mill.ltp.MorselQueue;
import org.duracloud.mill.ltp.RunStats;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoopingTaskProducer<T extends Morsel>
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(LoopingTaskProducer.class);
    private TaskQueue taskQueue;
    private CredentialsRepo credentialsRepo;
    private StateManager<T> stateManager;
    private int maxTaskQueueSize;
    private StorageProviderFactory storageProviderFactory;
    private List<T> morselsToReload = new LinkedList<T>();
    private Frequency frequency;
    private RunStats cumulativeTotals;
    private NotificationManager notificationManager;
    private LoopingTaskProducerConfigurationManager config;
    private Map<String, RunStats> runstats = new HashMap<String, RunStats>();

    public LoopingTaskProducer(CredentialsRepo credentialsRepo, StorageProviderFactory storageProviderFactory, TaskQueue taskQueue, StateManager<T> state, int maxTaskQueueSize, Frequency frequency, NotificationManager notificationManager, LoopingTaskProducerConfigurationManager config) {
        this.credentialsRepo = credentialsRepo;
        this.storageProviderFactory = storageProviderFactory;
        this.taskQueue = taskQueue;
        this.stateManager = state;
        this.credentialsRepo = credentialsRepo;
        this.maxTaskQueueSize = maxTaskQueueSize;
        this.frequency = frequency;
        this.cumulativeTotals = this.createRunStats();
        this.notificationManager = notificationManager;
        this.config = config;
    }

    protected Frequency getFrequency() {
        return this.frequency;
    }

    protected CredentialsRepo getCredentialsRepo() {
        return this.credentialsRepo;
    }

    protected TaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    protected int getMaxTaskQueueSize() {
        return this.maxTaskQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.deleteCompletionFileIfExists();
        Timer timer = new Timer();
        try {
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    LoopingTaskProducer.this.logSessionStats();
                }
            }, 300000L, 300000L);
            if (this.runLater()) {
                return;
            }
            log.info("Starting run...");
            Queue<T> morselQueue = this.loadMorselQueue();
            while (!morselQueue.isEmpty() && this.taskQueue.size() < this.maxTaskQueueSize) {
                Morsel morsel = (Morsel)morselQueue.peek();
                this.nibble(morselQueue);
                this.persistMorsels(morselQueue, this.morselsToReload);
                if (morselQueue.isEmpty()) {
                    morselQueue = this.reloadMorselQueue();
                    continue;
                }
                if (!morsel.equals(morselQueue.peek())) continue;
                break;
            }
            if (morselQueue.isEmpty()) {
                this.scheduleNextRun();
                this.writeCompletionFile();
            }
            this.logSessionStats();
            log.info("Session ended.");
        }
        finally {
            timer.cancel();
        }
    }

    private void writeCompletionFile() {
        File completionFile = this.getCompletionFile();
        try {
            if (completionFile.createNewFile()) {
                log.info("successfully created completion marker file: {}", (Object)completionFile.getAbsolutePath());
            } else {
                log.warn("completion marker file unexpectably exists already - something may be amiss: {}", (Object)completionFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error("Unable to create the completion file {}: {}", (Object)completionFile.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    private void deleteCompletionFileIfExists() {
        File completionFile = this.getCompletionFile();
        if (completionFile.exists()) {
            completionFile.delete();
        }
    }

    private File getCompletionFile() {
        return new File(this.config.getWorkDirectoryPath(), this.getLoopingProducerTypePrefix() + "-producer-complete.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIncrementalSessionStats() {
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            for (String account : this.runstats.keySet()) {
                RunStats stats = this.runstats.get(account);
                stats.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunStats calculateStatTotals(RunStats currentTotals) {
        RunStats totals = this.createRunStats();
        totals.copyValuesFrom(currentTotals);
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            for (String account : this.runstats.keySet()) {
                RunStats stats = this.runstats.get(account);
                totals.add(stats);
            }
            return totals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSessionStats() {
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            for (String account : this.runstats.keySet()) {
                RunStats stats = this.runstats.get(account);
                this.logIncrementalStatsByAccount(account, stats);
            }
            RunStats incrementalTotals = this.calculateStatTotals(this.createRunStats());
            this.logGlobalncrementalStats(incrementalTotals);
            this.cumulativeTotals = this.calculateStatTotals(this.cumulativeTotals);
            this.logCumulativeSessionStats(this.runstats, this.cumulativeTotals);
            this.resetIncrementalSessionStats();
        }
    }

    private void scheduleNextRun() {
        Date currentStartDate = this.stateManager.getCurrentRunStartDate();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(currentStartDate.getTime());
        c.add(this.frequency.getTimeUnit(), this.frequency.getValue());
        Date nextRun = c.getTime();
        this.stateManager.setNextRunStartDate(nextRun);
        this.stateManager.setCurrentRunStartDate(null);
        String hostname = "unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("unable to get hostname:" + e.getMessage());
        }
        String subject = this.getClass().getSimpleName() + "'s run completed on " + hostname;
        StringBuilder builder = new StringBuilder();
        builder.append(subject + "\n");
        builder.append(this.cumulativeTotals.toString() + "\n");
        builder.append("Scheduling the next run for " + nextRun + "\n");
        log.info(subject + ": next run will start " + nextRun);
        this.notificationManager.sendEmail(subject, builder.toString());
    }

    private boolean runLater() {
        boolean runLater = true;
        Date nextRun = this.stateManager.getNextRunStartDate();
        if (nextRun != null) {
            Date now = new Date();
            if (now.after(nextRun)) {
                this.stateManager.setCurrentRunStartDate(now);
                this.stateManager.setNextRunStartDate(null);
                runLater = false;
                log.info("Time to start a new run: the next run was scheduled to run on {}. Let's roll.", (Object)nextRun);
            } else {
                log.info("It's not yet time start a new run: the next run is scheduled to run on {}.", (Object)nextRun);
            }
        } else {
            Date currentRunStartDate = this.stateManager.getCurrentRunStartDate();
            if (currentRunStartDate == null) {
                this.stateManager.setCurrentRunStartDate(new Date());
                log.info("We're starting the first run on this machine");
            } else {
                log.info("We're continuing the current run which was started on {}", (Object)currentRunStartDate);
            }
            runLater = false;
        }
        return runLater;
    }

    private MorselQueue<T> reloadMorselQueue() {
        List<T> morsels = this.morselsToReload;
        this.morselsToReload = new LinkedList<T>();
        MorselQueue queue = new MorselQueue();
        queue.addAll(morsels);
        return queue;
    }

    private Queue<T> loadMorselQueue() {
        Queue<T> morselQueue = this.createQueue();
        LinkedHashSet<T> morsels = new LinkedHashSet<T>(this.stateManager.getMorsels());
        morselQueue.addAll(morsels);
        if (morselQueue.isEmpty()) {
            this.loadMorselQueueFromSource(morselQueue);
        }
        return morselQueue;
    }

    protected Queue<T> createQueue() {
        return new LinkedList();
    }

    private void persistMorsels(Queue<T> queue, List<T> morselsToReload) {
        LinkedHashSet<T> morsels = new LinkedHashSet<T>();
        morsels.addAll(queue);
        morsels.addAll(morselsToReload);
        this.stateManager.setMorsels(morsels);
    }

    protected void addToReloadList(T morsel) {
        log.info("adding morsel to reload list: {}", (Object)morsel);
        this.morselsToReload.add(morsel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunStats getStats(String account) {
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            RunStats stats = this.runstats.get(account);
            if (stats == null) {
                stats = this.createRunStats();
                this.runstats.put(account, stats);
            }
            return stats;
        }
    }

    protected StorageProvider getStorageProvider(String account, String storeId) {
        StorageProviderCredentials creds;
        try {
            creds = this.credentialsRepo.getStorageProviderCredentials(account, storeId);
        }
        catch (CredentialsRepoException e) {
            throw new RuntimeException(e);
        }
        return this.getStorageProvider(creds);
    }

    protected StorageProvider getStorageProvider(StorageProviderCredentials creds) {
        return this.storageProviderFactory.create(creds);
    }

    protected abstract void loadMorselQueueFromSource(Queue<T> var1);

    protected abstract void nibble(Queue<T> var1);

    protected abstract RunStats createRunStats();

    protected abstract void logGlobalncrementalStats(RunStats var1);

    protected abstract void logIncrementalStatsByAccount(String var1, RunStats var2);

    protected abstract void logCumulativeSessionStats(Map<String, RunStats> var1, RunStats var2);

    protected abstract String getLoopingProducerTypePrefix();
}

