/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.openstackstorage;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.duracloud.common.stream.ChecksumInputStream;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.DateUtil;
import org.duracloud.storage.domain.ContentIterator;
import org.duracloud.storage.error.ChecksumMismatchException;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProviderBase;
import org.duracloud.storage.util.StorageProviderUtil;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.enterprise.config.EnterpriseConfigurationModule;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.swift.CopyObjectException;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.options.CreateContainerOptions;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenStackStorageProvider
extends StorageProviderBase {
    private static final Logger log = LoggerFactory.getLogger(OpenStackStorageProvider.class);
    private SwiftClient swiftClient = null;

    public OpenStackStorageProvider(String username, String apiAccessKey, String authUrl) {
        if (null == authUrl) {
            authUrl = this.getAuthUrl();
        }
        try {
            String trimmedAuthUrl = authUrl.substring(0, authUrl.lastIndexOf("/"));
            ListeningExecutorService useExecutor = this.createThreadPool();
            ListeningExecutorService ioExecutor = this.createThreadPool();
            ImmutableSet<EnterpriseConfigurationModule> modules = ImmutableSet.of(new EnterpriseConfigurationModule(useExecutor, ioExecutor));
            Properties properties = new Properties();
            properties.setProperty("jclouds.strip-expect-header", "true");
            this.swiftClient = ContextBuilder.newBuilder(new SwiftApiMetadata()).endpoint(trimmedAuthUrl).credentials(username, apiAccessKey).modules(modules).overrides(properties).buildApi(SwiftClient.class);
        }
        catch (Exception e) {
            String err = "Could not connect to " + this.getProviderName() + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    protected ListeningExecutorService createThreadPool() {
        return MoreExecutors.listeningDecorator(new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()));
    }

    public OpenStackStorageProvider(String username, String apiAccessKey) {
        this(username, apiAccessKey, null);
    }

    public OpenStackStorageProvider(SwiftClient swiftClient) {
        this.swiftClient = swiftClient;
    }

    public abstract String getAuthUrl();

    public abstract String getProviderName();

    @Override
    public Iterator<String> getSpaces() {
        log.debug("getSpace()");
        Set<ContainerMetadata> containers = this.swiftClient.listContainers(ListContainerOptions.NONE);
        ArrayList<String> spaces = new ArrayList<String>();
        for (ContainerMetadata container : containers) {
            String containerName = container.getName();
            spaces.add(containerName);
        }
        return spaces.iterator();
    }

    @Override
    public Iterator<String> getSpaceContents(String spaceId, String prefix) {
        log.debug("getSpaceContents(" + spaceId + ", " + prefix);
        this.throwIfSpaceNotExist(spaceId);
        return new ContentIterator(this, spaceId, prefix);
    }

    @Override
    public List<String> getSpaceContentsChunked(String spaceId, String prefix, long maxResults, String marker) {
        log.debug("getSpaceContentsChunked(" + spaceId + ", " + prefix + ", " + maxResults + ", " + marker + ")");
        this.throwIfSpaceNotExist(spaceId);
        if (maxResults <= 0L) {
            maxResults = 1000L;
        }
        List<String> spaceContents = this.getCompleteSpaceContents(spaceId, prefix, maxResults, marker);
        return spaceContents;
    }

    private List<String> getCompleteSpaceContents(String spaceId, String prefix, long maxResults, String marker) {
        String containerName = this.getContainerName(spaceId);
        PageSet<ObjectInfo> objects = this.listObjects(containerName, prefix, maxResults, marker);
        ArrayList<String> contentItems = new ArrayList<String>();
        for (ObjectInfo object : objects) {
            contentItems.add(object.getName());
        }
        return contentItems;
    }

    private PageSet<ObjectInfo> listObjects(String containerName, String prefix, long maxResults, String marker) {
        int limit = new Long(maxResults).intValue();
        ListContainerOptions containerOptions = ListContainerOptions.Builder.maxResults(limit);
        if (marker != null) {
            containerOptions.afterMarker(marker);
        }
        if (prefix != null) {
            containerOptions.withPrefix(prefix);
        }
        return this.swiftClient.listObjects(containerName, containerOptions);
    }

    private void throwIfContentNotExist(String spaceId, String contentId) {
        log.debug("throwIfContentNotExist({}, {})", (Object)spaceId, (Object)contentId);
        String containerName = this.getContainerName(spaceId);
        boolean exists = false;
        try {
            exists = this.swiftClient.objectExists(containerName, contentId);
        }
        catch (ContainerNotFoundException e) {
            log.debug("object does not exist: {}, {}", (Object)containerName, (Object)contentId);
            String errMsg = this.createNotFoundMsg(containerName, contentId);
            throw new NotFoundException(errMsg, e);
        }
        if (!exists) {
            log.debug("object does not exist: {}, {}", (Object)containerName, (Object)contentId);
            String errMsg = this.createNotFoundMsg(containerName, contentId);
            throw new NotFoundException(errMsg);
        }
        log.debug("object does exist: {}, {}", (Object)containerName, (Object)contentId);
    }

    @Override
    protected boolean spaceExists(String spaceId) {
        String containerName = this.getContainerName(spaceId);
        return this.swiftClient.containerExists(containerName);
    }

    @Override
    public void createSpace(String spaceId) {
        log.debug("getCreateSpace(" + spaceId + ")");
        this.throwIfSpaceExists(spaceId);
        HashMap<String, String> spaceProperties = new HashMap<String, String>();
        spaceProperties.put("space-created", DateUtil.convertToString(System.currentTimeMillis()));
        CreateContainerOptions createContainerOptions = CreateContainerOptions.Builder.withMetadata(spaceProperties);
        String containerName = this.getContainerName(spaceId);
        this.swiftClient.createContainer(containerName, createContainerOptions);
    }

    @Override
    protected void doSetSpaceProperties(String spaceId, Map<String, String> spaceProperties) {
        log.debug("doSetSpaceProperties(" + spaceId + ")");
        this.throwIfSpaceNotExist(spaceId);
        String created = this.getCreationTimestamp(spaceId, spaceProperties);
        if (created != null) {
            spaceProperties.put("space-created", created);
        }
        String containerName = this.getContainerName(spaceId);
        this.swiftClient.setContainerMetadata(containerName, spaceProperties);
    }

    @Override
    public void removeSpace(String spaceId) {
        String containerName = this.getContainerName(spaceId);
        boolean successful = this.swiftClient.deleteContainerIfEmpty(containerName);
        if (!successful) {
            StringBuilder err = new StringBuilder("Could not delete " + this.getProviderName() + " container with name " + containerName + " due to error: container not empty");
            throw new StorageException(err.toString(), false);
        }
    }

    @Override
    protected Map<String, String> getAllSpaceProperties(String spaceId) {
        log.debug("getAllSpaceProperties(" + spaceId + ")");
        this.throwIfSpaceNotExist(spaceId);
        String containerName = this.getContainerName(spaceId);
        ContainerMetadata containerMetadata = this.swiftClient.getContainerMetadata(containerName);
        Map<String, String> metadata = containerMetadata.getMetadata();
        HashMap<String, String> spaceProperties = new HashMap<String, String>();
        spaceProperties.putAll(metadata);
        spaceProperties.put("space-count", String.valueOf(containerMetadata.getCount()));
        spaceProperties.put("space-total-size", String.valueOf(containerMetadata.getBytes()));
        return spaceProperties;
    }

    private String getCreationTimestamp(String spaceId, Map<String, String> spaceProperties) {
        String creationTime = null;
        if (!spaceProperties.containsKey("space-created")) {
            Map<String, String> spaceMd = this.getAllSpaceProperties(spaceId);
            creationTime = spaceMd.get("space-created");
        } else {
            creationTime = spaceProperties.get("space-created");
        }
        if (creationTime == null) {
            StringBuffer msg = new StringBuffer("Error: ");
            msg.append("No ").append("space-created").append(" found ");
            msg.append("for spaceId: ").append(spaceId);
            log.error(msg.toString());
            creationTime = ISO8601_DATE_FORMAT.format(new Date());
        }
        return creationTime;
    }

    @Override
    public String addContent(String spaceId, String contentId, String contentMimeType, Map<String, String> userProperties, long contentSize, String contentChecksum, InputStream content) {
        log.debug("addContent(" + spaceId + ", " + contentId + ", " + contentMimeType + ", " + contentSize + ", " + contentChecksum + ")");
        this.throwIfSpaceNotExist(spaceId);
        if (contentMimeType == null || contentMimeType.equals("")) {
            contentMimeType = "application/octet-stream";
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("content-mimetype", contentMimeType);
        if (userProperties != null) {
            userProperties = this.removeCalculatedProperties(userProperties);
            for (String key : userProperties.keySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("[" + key + "|" + userProperties.get(key) + "]");
                }
                properties.put(this.getSpaceFree(key), userProperties.get(key));
            }
        }
        ChecksumInputStream wrappedContent = new ChecksumInputStream(content, contentChecksum);
        String containerName = this.getContainerName(spaceId);
        SwiftObject swiftObject = this.swiftClient.newSwiftObject();
        MutableObjectInfoWithMetadata objectInfoMetadata = swiftObject.getInfo();
        objectInfoMetadata.setName(contentId);
        objectInfoMetadata.setContentType(contentMimeType);
        objectInfoMetadata.getMetadata().putAll(properties);
        swiftObject.setPayload(wrappedContent);
        String providerChecksum = this.swiftClient.putObject(containerName, swiftObject);
        try {
            String checksum = wrappedContent.getMD5();
            StorageProviderUtil.compareChecksum(providerChecksum, spaceId, contentId, checksum);
        }
        catch (ChecksumMismatchException e) {
            if (this.swiftClient.objectExists(containerName, contentId)) {
                this.swiftClient.removeObject(containerName, contentId);
            }
            throw e;
        }
        return providerChecksum;
    }

    @Override
    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        log.debug("copyContent({}, {}, {}, {})", sourceSpaceId, sourceContentId, destSpaceId, destContentId);
        this.throwIfContentNotExist(sourceSpaceId, sourceContentId);
        this.throwIfSpaceNotExist(destSpaceId);
        if (this.doCopyContent(sourceSpaceId, sourceContentId, destSpaceId, destContentId)) {
            MutableObjectInfoWithMetadata objectInfoWithMetadata = this.getObjectProperties(destSpaceId, destContentId);
            byte[] hash = objectInfoWithMetadata.getHash();
            String md5 = null;
            if (hash != null) {
                md5 = ChecksumUtil.checksumBytesToString(hash);
            }
            return StorageProviderUtil.compareChecksum(this, sourceSpaceId, sourceContentId, md5);
        }
        throw new StorageException("failed to copy object - srcSpaceId: " + sourceSpaceId + ", " + "sourceContentId: " + sourceContentId + ", " + "destSpaceId: " + destSpaceId + ", " + "destContentId: " + destContentId);
    }

    private boolean doCopyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        try {
            return this.swiftClient.copyObject(sourceSpaceId, sourceContentId, destSpaceId, destContentId);
        }
        catch (CopyObjectException e) {
            StringBuilder err = new StringBuilder("Could not copy content from: ");
            err.append(sourceSpaceId);
            err.append(" / ");
            err.append(sourceContentId);
            err.append(", to: ");
            err.append(destSpaceId);
            err.append(" / ");
            err.append(destContentId);
            err.append(", due to error: ");
            err.append(e.getMessage());
            throw new StorageException(err.toString(), (Throwable)e, true);
        }
    }

    @Override
    public InputStream getContent(String spaceId, String contentId) {
        log.debug("getContent(" + spaceId + ", " + contentId + ")");
        this.throwIfSpaceNotExist(spaceId);
        String containerName = this.getContainerName(spaceId);
        SwiftObject swiftObject = this.swiftClient.getObject(containerName, contentId, new GetOptions[0]);
        if (swiftObject == null) {
            String errMsg = this.createNotFoundMsg(spaceId, contentId);
            throw new NotFoundException(errMsg);
        }
        InputStream content = swiftObject.getPayload().getInput();
        return content;
    }

    private String createNotFoundMsg(String spaceId, String contentId) {
        StringBuilder msg = new StringBuilder(this.getProviderName());
        msg.append(": Could not find content item with ID ");
        msg.append(contentId);
        msg.append(" in space ");
        msg.append(spaceId);
        return msg.toString();
    }

    @Override
    public void deleteContent(String spaceId, String contentId) {
        log.debug("deleteContent({}, {})", (Object)spaceId, (Object)contentId);
        this.throwIfContentNotExist(spaceId, contentId);
        log.debug("after check exist: {}, {}", (Object)spaceId, (Object)contentId);
        String containerName = this.getContainerName(spaceId);
        log.debug("before swiftClient.removeObject({}, {})", (Object)spaceId, (Object)contentId);
        this.swiftClient.removeObject(containerName, contentId);
    }

    @Override
    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) {
        log.debug("setContentProperties(" + spaceId + ", " + contentId + ")");
        this.throwIfSpaceNotExist(spaceId);
        this.throwIfContentNotExist(spaceId, contentId);
        contentProperties = this.removeCalculatedProperties(contentProperties);
        String contentMimeType = contentProperties.remove("content-mimetype");
        if (contentMimeType == null || contentMimeType.equals("")) {
            contentMimeType = this.getContentProperties(spaceId, contentId).get("content-mimetype");
        }
        HashMap<String, String> newContentProperties = new HashMap<String, String>();
        for (String key : contentProperties.keySet()) {
            if (log.isDebugEnabled()) {
                log.debug("[" + key + "|" + contentProperties.get(key) + "]");
            }
            newContentProperties.put(this.getSpaceFree(key), contentProperties.get(key));
        }
        if (contentMimeType != null && !contentMimeType.equals("")) {
            newContentProperties.put("content-mimetype", contentMimeType);
        }
        String containerName = this.getContainerName(spaceId);
        log.debug("Calling swiftClient.setObjectInfo for spaceId: {} and contentId: {}", (Object)spaceId, (Object)contentId);
        if (!this.swiftClient.setObjectInfo(containerName, contentId, newContentProperties)) {
            String errMsg = this.createNotFoundMsg(spaceId, contentId);
            throw new StorageException("Error setting content properties");
        }
    }

    @Override
    public Map<String, String> getContentProperties(String spaceId, String contentId) {
        Date modified;
        byte[] hash;
        log.debug("getContentProperties(" + spaceId + ", " + contentId + ")");
        this.throwIfSpaceNotExist(spaceId);
        MutableObjectInfoWithMetadata objectInfoWithMetadata = this.getObjectProperties(spaceId, contentId);
        if (objectInfoWithMetadata == null) {
            String err = "No properties are available for item " + contentId + " in " + this.getProviderName() + " space " + spaceId;
            throw new StorageException(err, true);
        }
        Map<String, String> propertiesMap = objectInfoWithMetadata.getMetadata();
        Long contentLength = objectInfoWithMetadata.getBytes();
        if (contentLength != null) {
            propertiesMap.put("content-size", contentLength.toString());
        }
        if ((hash = objectInfoWithMetadata.getHash()) != null) {
            String checksum = ChecksumUtil.checksumBytesToString(hash);
            propertiesMap.put("content-checksum", checksum);
        }
        if ((modified = objectInfoWithMetadata.getLastModified()) != null) {
            String formatted = DateUtil.convertToString(modified.getTime());
            propertiesMap.put("content-modified", formatted);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String key : propertiesMap.keySet()) {
            String val = propertiesMap.get(key);
            resultMap.put(this.getWithSpace(key.toLowerCase()), val);
        }
        return resultMap;
    }

    private MutableObjectInfoWithMetadata getObjectProperties(String spaceId, String contentId) {
        String containerName = this.getContainerName(spaceId);
        MutableObjectInfoWithMetadata objectInfoWithMetadata = this.swiftClient.getObjectInfo(containerName, contentId);
        if (objectInfoWithMetadata == null) {
            String errMsg = this.createNotFoundMsg(spaceId, contentId);
            throw new NotFoundException(errMsg);
        }
        return objectInfoWithMetadata;
    }

    protected String getContainerName(String spaceId) {
        String containerName = spaceId;
        containerName = containerName.replaceAll("/", "-");
        containerName = containerName.replaceAll("[?]", "-");
        containerName = containerName.replaceAll("[-]+", "-");
        if ((containerName = OpenStackStorageProvider.sanitizeForURI(containerName)).length() > 63) {
            containerName = containerName.substring(0, 63);
        }
        return containerName;
    }

    public static String sanitizeForURI(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(str).replaceAll("\\+", "%20");
        }
        catch (EncoderException ee) {
            log.warn("Error trying to encode string for URI", ee);
            return str;
        }
    }

    protected String getSpaceFree(String name) {
        return name.replaceAll(" ", "%20");
    }

    protected String getWithSpace(String name) {
        return name.replaceAll("%20", " ");
    }
}

