/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.s3.AmazonS3Client;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.jets3t.service.model.cloudfront.StreamingDistributionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStreamingTaskRunner
implements TaskRunner {
    private final Logger log = LoggerFactory.getLogger(BaseStreamingTaskRunner.class);
    public static final String STREAMING_HOST_PROP = "streaming-host";
    protected static final int maxRetries = 8;
    protected StorageProvider s3Provider;
    protected S3StorageProvider unwrappedS3Provider;
    protected AmazonS3Client s3Client;
    protected CloudFrontService cfService;

    @Override
    public abstract String getName();

    @Override
    public abstract String performTask(String var1);

    protected String getSpaceId(String taskParameters) {
        if (taskParameters != null && !taskParameters.equals("")) {
            return taskParameters;
        }
        throw new RuntimeException("A Space ID must be provided");
    }

    protected StreamingDistribution getExistingDistribution(String bucketName) throws CloudFrontServiceException {
        StreamingDistribution[] distributions = this.cfService.listStreamingDistributions();
        if (distributions != null) {
            for (StreamingDistribution dist : distributions) {
                if (!this.isDistFromBucket(bucketName, dist)) continue;
                return dist;
            }
        }
        return null;
    }

    private boolean isDistFromBucket(String bucketName, StreamingDistribution dist) {
        S3Origin origin = (S3Origin)dist.getOrigin();
        return bucketName.equals(origin.getOriginAsBucketName());
    }

    protected List<StreamingDistribution> getAllExistingDistributions(String bucketName) throws CloudFrontServiceException {
        StreamingDistribution[] distributions = this.cfService.listStreamingDistributions();
        ArrayList<StreamingDistribution> distList = new ArrayList<StreamingDistribution>();
        for (StreamingDistribution dist : distributions) {
            if (!this.isDistFromBucket(bucketName, dist)) continue;
            distList.add(dist);
        }
        return distList;
    }

    protected Iterator<String> getSpaceContents(String spaceId) {
        for (int i = 0; i < 8; ++i) {
            try {
                return this.s3Provider.getSpaceContents(spaceId, null);
            }
            catch (Exception e) {
                this.log.warn("Exception encountered attempting to get contents for streaming space: " + spaceId + ", error message: " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        throw new DuraCloudRuntimeException("Exceeded retries attempting to get space contents for " + spaceId);
    }

    protected String getDistributionOriginAccessId(String distributionId) throws CloudFrontServiceException {
        StreamingDistributionConfig config = this.cfService.getStreamingDistributionConfig(distributionId);
        S3Origin origin = (S3Origin)config.getOrigin();
        return origin.getOriginAccessIdentity();
    }

    protected void removeStreamingHostFromSpaceProps(String spaceId) {
        Map<String, String> spaceProps = this.s3Provider.getSpaceProperties(spaceId);
        if (spaceProps.containsKey(STREAMING_HOST_PROP)) {
            spaceProps.remove(STREAMING_HOST_PROP);
            this.unwrappedS3Provider.setNewSpaceProperties(spaceId, spaceProps);
        }
    }

    protected void wait(int index) {
        try {
            Thread.sleep(1000 * index);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

