/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIdentityVerificationAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityVerificationAttributesRequest>, GetIdentityVerificationAttributesRequest> {
    @Override
    public Request<GetIdentityVerificationAttributesRequest> marshall(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        if (getIdentityVerificationAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetIdentityVerificationAttributesRequest> request = new DefaultRequest<GetIdentityVerificationAttributesRequest>(getIdentityVerificationAttributesRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "GetIdentityVerificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList identitiesList = (SdkInternalList)getIdentityVerificationAttributesRequest.getIdentities();
        if (!identitiesList.isEmpty() || !identitiesList.isAutoConstruct()) {
            int identitiesListIndex = 1;
            for (String identitiesListValue : identitiesList) {
                if (identitiesListValue != null) {
                    request.addParameter("Identities.member." + identitiesListIndex, StringUtils.fromString(identitiesListValue));
                }
                ++identitiesListIndex;
            }
        }
        return request;
    }
}

