/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.impl;

import java.util.ArrayList;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.UserFinderUtil;
import org.duracloud.common.cache.AbstractAccountComponentCache;
import org.duracloud.common.event.AccountChangeEvent;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.domain.SecurityUserBean;
import org.duracloud.security.impl.UserDetailsServiceImpl;

public class UserDetailsServiceCache
extends AbstractAccountComponentCache<DuracloudUserDetailsService> {
    private DuracloudAccountRepo accountRepo;
    private UserFinderUtil userFinderUtil;

    public UserDetailsServiceCache(DuracloudAccountRepo accountRepo, UserFinderUtil userFinderUtil) {
        this.accountRepo = accountRepo;
        this.userFinderUtil = userFinderUtil;
    }

    @Override
    public void onEvent(AccountChangeEvent event) {
        String accountId = event.getAccountId();
        AccountChangeEvent.EventType eventType = event.getEventType();
        if (accountId != null) {
            if (eventType.equals((Object)AccountChangeEvent.EventType.USERS_CHANGED) || eventType.equals((Object)AccountChangeEvent.EventType.ACCOUNT_CHANGED)) {
                this.remove(accountId);
            }
        } else if (eventType.equals((Object)AccountChangeEvent.EventType.ALL_ACCOUNTS_CHANGED)) {
            this.removeAll();
        }
    }

    @Override
    protected DuracloudUserDetailsService createInstance(String accountId) {
        UserDetailsServiceImpl userDetails = new UserDetailsServiceImpl();
        this.initializeUserDetails(userDetails, accountId);
        return userDetails;
    }

    private void initializeUserDetails(UserDetailsServiceImpl userDetails, String accountId) {
        AccountInfo info = this.accountRepo.findBySubdomain(accountId);
        Set<DuracloudUser> dusers = this.userFinderUtil.getAccountUsers(info);
        Set<SecurityUserBean> securityBeans = this.userFinderUtil.convertDuracloudUsersToSecurityUserBeans(info, dusers, true);
        userDetails.setUsers(new ArrayList<SecurityUserBean>(securityBeans));
    }
}

