/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.bridge.CreateRestoreBridgeParameters;
import org.duracloud.snapshot.dto.bridge.CreateRestoreBridgeResult;
import org.duracloud.snapshot.dto.task.RestoreSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.RestoreSnapshotTaskResult;
import org.duracloud.snapshot.id.SnapshotIdentifier;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreSnapshotTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(RestoreSnapshotTaskRunner.class);
    private StorageProvider snapshotProvider;
    private SnapshotStorageProvider unwrappedSnapshotProvider;
    private String dcHost;
    private String dcPort;
    private String dcStoreId;
    private String dcSnapshotUser;

    public RestoreSnapshotTaskRunner(StorageProvider snapshotProvider, SnapshotStorageProvider unwrappedSnapshotProvider, String dcHost, String dcPort, String dcStoreId, String dcSnapshotUser, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.snapshotProvider = snapshotProvider;
        this.unwrappedSnapshotProvider = unwrappedSnapshotProvider;
        this.dcHost = dcHost;
        this.dcPort = dcPort;
        this.dcStoreId = dcStoreId;
        this.dcSnapshotUser = dcSnapshotUser;
    }

    @Override
    public String getName() {
        return "restore-snapshot";
    }

    @Override
    public String performTask(String taskParameters) {
        SnapshotIdentifier snapshotIdentifier;
        this.log.info("Performing RESTORE task with parameters, DuraCloud Host: {} DuraCloud Port: {} DuraCloud StoreID: {} DuraCloud Snapshot User: {} Bridge Host: {} Bridge Port: {} Bridge User: {}", this.dcHost, this.dcPort, this.dcStoreId, this.dcSnapshotUser, this.getBridgeAppHost(), this.getBridgeAppPort(), this.getBridgeAppUser());
        RestoreSnapshotTaskParameters taskParams = RestoreSnapshotTaskParameters.deserialize(taskParameters);
        String snapshotId = taskParams.getSnapshotId();
        try {
            snapshotIdentifier = SnapshotIdentifier.parseSnapshotId(snapshotId);
        }
        catch (ParseException e) {
            throw new TaskException("Invalid Snapshot ID: " + snapshotId);
        }
        this.checkExistingRestore(snapshotIdentifier);
        String restoreSpaceId = snapshotIdentifier.getRestoreSpaceId();
        this.createSpace(restoreSpaceId);
        String bridgeURL = this.buildBridgeURL();
        String bridgeBody = this.buildBridgeBody(restoreSpaceId, snapshotId, taskParams.getUserEmail());
        String callResult = this.callBridge(this.createRestHelper(), bridgeURL, bridgeBody);
        CreateRestoreBridgeResult bridgeResult = CreateRestoreBridgeResult.deserialize(callResult);
        this.addRestoreIdToSpaceProps(restoreSpaceId, bridgeResult.getRestoreId());
        this.setRestoreSpaceUserPermissions(restoreSpaceId);
        RestoreSnapshotTaskResult taskResult = new RestoreSnapshotTaskResult();
        taskResult.setSpaceId(restoreSpaceId);
        taskResult.setRestoreId(bridgeResult.getRestoreId());
        taskResult.setStatus(bridgeResult.getStatus());
        return taskResult.serialize();
    }

    protected void checkExistingRestore(SnapshotIdentifier snapshotIdentifier) {
        Iterator<String> currentSpaces = this.snapshotProvider.getSpaces();
        while (currentSpaces.hasNext()) {
            String spaceId = currentSpaces.next();
            if (!spaceId.equals(snapshotIdentifier.getRestoreSpaceId())) continue;
            String error = "A request to restore snapshot with ID " + snapshotIdentifier.getSnapshotId() + " has been made previously. The snapshot is being restored to space: " + spaceId;
            throw new TaskException(error);
        }
    }

    protected String createSpace(final String spaceId) {
        try {
            Retrier retrier = new Retrier();
            return (String)retrier.execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    RestoreSnapshotTaskRunner.this.snapshotProvider.createSpace(spaceId);
                    return spaceId;
                }
            });
        }
        catch (Exception e) {
            throw new TaskException("Unable to initialize snapshot restore, failed creating restore space due to: " + e.getMessage(), e);
        }
    }

    protected String setRestoreSpaceUserPermissions(final String spaceId) {
        try {
            Retrier retrier = new Retrier();
            return (String)retrier.execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    HashMap<String, AclType> spaceACLs = new HashMap<String, AclType>();
                    spaceACLs.put("acl-" + RestoreSnapshotTaskRunner.this.dcSnapshotUser, AclType.READ);
                    spaceACLs.put("acl-" + RestoreSnapshotTaskRunner.this.dcSnapshotUser, AclType.WRITE);
                    RestoreSnapshotTaskRunner.this.snapshotProvider.setSpaceACLs(spaceId, spaceACLs);
                    return spaceId;
                }
            });
        }
        catch (Exception e) {
            throw new TaskException("Unable to initialize snapshot restore, failed setting space permissions due to: " + e.getMessage(), e);
        }
    }

    protected String buildBridgeURL() {
        return MessageFormat.format("{0}/restore", this.buildBridgeBaseURL());
    }

    protected String buildBridgeBody(String spaceId, String snapshotId, String userEmail) {
        CreateRestoreBridgeParameters bridgeParams = new CreateRestoreBridgeParameters(this.dcHost, this.dcPort, this.dcStoreId, spaceId, snapshotId, userEmail);
        return bridgeParams.serialize();
    }

    protected String callBridge(RestHttpHelper restHelper, String snapshotURL, String snapshotBody) {
        this.log.info("Making RESTORE call to URL {} with body {}", (Object)snapshotURL, (Object)snapshotBody);
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            RestHttpHelper.HttpResponse response = restHelper.put(snapshotURL, snapshotBody, headers);
            int statusCode = response.getStatusCode();
            if (statusCode != 201) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to initiate snapshot request. Error reported: " + e.getMessage(), e);
        }
    }

    protected void addRestoreIdToSpaceProps(String restoreSpaceId, String restoreId) {
        Map<String, String> restoreSpaceProps = this.snapshotProvider.getSpaceProperties(restoreSpaceId);
        restoreSpaceProps.put("restore-id", restoreId);
        this.unwrappedSnapshotProvider.setNewSpaceProperties(restoreSpaceId, restoreSpaceProps);
    }
}

