/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.switchuser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.switchuser.AuthenticationSwitchUserEvent;
import org.springframework.security.web.authentication.switchuser.SwitchUserAuthorityChanger;
import org.springframework.security.web.authentication.switchuser.SwitchUserGrantedAuthority;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchUserFilter
extends GenericFilterBean
implements ApplicationEventPublisherAware,
MessageSourceAware {
    public static final String SPRING_SECURITY_SWITCH_USERNAME_KEY = "username";
    public static final String ROLE_PREVIOUS_ADMINISTRATOR = "ROLE_PREVIOUS_ADMINISTRATOR";
    private ApplicationEventPublisher eventPublisher;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private String exitUserUrl = "/logout/impersonate";
    private String switchUserUrl = "/login/impersonate";
    private String targetUrl;
    private String switchFailureUrl;
    private String usernameParameter = "username";
    private SwitchUserAuthorityChanger switchUserAuthorityChanger;
    private UserDetailsService userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private AuthenticationSuccessHandler successHandler;
    private AuthenticationFailureHandler failureHandler;

    @Override
    public void afterPropertiesSet() {
        Assert.notNull(this.userDetailsService, "userDetailsService must be specified");
        Assert.isTrue(this.successHandler != null || this.targetUrl != null, "You must set either a successHandler or the targetUrl");
        if (this.targetUrl != null) {
            Assert.isNull(this.successHandler, "You cannot set both successHandler and targetUrl");
            this.successHandler = new SimpleUrlAuthenticationSuccessHandler(this.targetUrl);
        }
        if (this.failureHandler == null) {
            this.failureHandler = this.switchFailureUrl == null ? new SimpleUrlAuthenticationFailureHandler() : new SimpleUrlAuthenticationFailureHandler(this.switchFailureUrl);
        } else {
            Assert.isNull(this.switchFailureUrl, "You cannot set both a switchFailureUrl and a failureHandler");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.requiresSwitchUser(request)) {
            try {
                Authentication targetUser = this.attemptSwitchUser(request);
                SecurityContextHolder.getContext().setAuthentication(targetUser);
                this.successHandler.onAuthenticationSuccess(request, response, targetUser);
            }
            catch (AuthenticationException e) {
                this.logger.debug("Switch User failed", e);
                this.failureHandler.onAuthenticationFailure(request, response, e);
            }
            return;
        }
        if (this.requiresExitUser(request)) {
            Authentication originalUser = this.attemptExitUser(request);
            SecurityContextHolder.getContext().setAuthentication(originalUser);
            this.successHandler.onAuthenticationSuccess(request, response, originalUser);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected Authentication attemptSwitchUser(HttpServletRequest request) throws AuthenticationException {
        String username = request.getParameter(this.usernameParameter);
        if (username == null) {
            username = "";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Attempt to switch to user [" + username + "]");
        }
        UserDetails targetUser = this.userDetailsService.loadUserByUsername(username);
        this.userDetailsChecker.check(targetUser);
        UsernamePasswordAuthenticationToken targetUserRequest = this.createSwitchUserToken(request, targetUser);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Switch User Token [" + targetUserRequest + "]");
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(new AuthenticationSwitchUserEvent(SecurityContextHolder.getContext().getAuthentication(), targetUser));
        }
        return targetUserRequest;
    }

    protected Authentication attemptExitUser(HttpServletRequest request) throws AuthenticationCredentialsNotFoundException {
        Authentication current = SecurityContextHolder.getContext().getAuthentication();
        if (null == current) {
            throw new AuthenticationCredentialsNotFoundException(this.messages.getMessage("SwitchUserFilter.noCurrentUser", "No current user associated with this request"));
        }
        Authentication original = this.getSourceAuthentication(current);
        if (original == null) {
            this.logger.debug("Could not find original user Authentication object!");
            throw new AuthenticationCredentialsNotFoundException(this.messages.getMessage("SwitchUserFilter.noOriginalAuthentication", "Could not find original Authentication object"));
        }
        UserDetails originalUser = null;
        Object obj = original.getPrincipal();
        if (obj != null && obj instanceof UserDetails) {
            originalUser = (UserDetails)obj;
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(new AuthenticationSwitchUserEvent(current, originalUser));
        }
        return original;
    }

    private UsernamePasswordAuthenticationToken createSwitchUserToken(HttpServletRequest request, UserDetails targetUser) {
        Authentication currentAuth;
        try {
            currentAuth = this.attemptExitUser(request);
        }
        catch (AuthenticationCredentialsNotFoundException e) {
            currentAuth = SecurityContextHolder.getContext().getAuthentication();
        }
        SwitchUserGrantedAuthority switchAuthority = new SwitchUserGrantedAuthority(ROLE_PREVIOUS_ADMINISTRATOR, currentAuth);
        Collection<? extends GrantedAuthority> orig = targetUser.getAuthorities();
        if (this.switchUserAuthorityChanger != null) {
            orig = this.switchUserAuthorityChanger.modifyGrantedAuthorities(targetUser, currentAuth, orig);
        }
        ArrayList<? extends GrantedAuthority> newAuths = new ArrayList<GrantedAuthority>(orig);
        newAuths.add(switchAuthority);
        UsernamePasswordAuthenticationToken targetUserRequest = new UsernamePasswordAuthenticationToken(targetUser, targetUser.getPassword(), newAuths);
        targetUserRequest.setDetails(this.authenticationDetailsSource.buildDetails(request));
        return targetUserRequest;
    }

    private Authentication getSourceAuthentication(Authentication current) {
        Authentication original = null;
        Collection<? extends GrantedAuthority> authorities = current.getAuthorities();
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!(grantedAuthority instanceof SwitchUserGrantedAuthority)) continue;
            original = ((SwitchUserGrantedAuthority)grantedAuthority).getSource();
            this.logger.debug("Found original switch user granted authority [" + original + "]");
        }
        return original;
    }

    protected boolean requiresExitUser(HttpServletRequest request) {
        String uri = this.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.exitUserUrl);
    }

    protected boolean requiresSwitchUser(HttpServletRequest request) {
        String uri = this.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.switchUserUrl);
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) throws BeansException {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, "AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        Assert.notNull(messageSource, "messageSource cannot be null");
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setExitUserUrl(String exitUserUrl) {
        Assert.isTrue(UrlUtils.isValidRedirectUrl(exitUserUrl), "exitUserUrl cannot be empty and must be a valid redirect URL");
        this.exitUserUrl = exitUserUrl;
    }

    public void setSwitchUserUrl(String switchUserUrl) {
        Assert.isTrue(UrlUtils.isValidRedirectUrl(switchUserUrl), "switchUserUrl cannot be empty and must be a valid redirect URL");
        this.switchUserUrl = switchUserUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void setSuccessHandler(AuthenticationSuccessHandler successHandler) {
        Assert.notNull(successHandler, "successHandler cannot be null");
        this.successHandler = successHandler;
    }

    public void setSwitchFailureUrl(String switchFailureUrl) {
        Assert.isTrue(StringUtils.hasText(this.switchUserUrl) && UrlUtils.isValidRedirectUrl(switchFailureUrl), "switchFailureUrl cannot be empty and must be a valid redirect URL");
        this.switchFailureUrl = switchFailureUrl;
    }

    public void setFailureHandler(AuthenticationFailureHandler failureHandler) {
        Assert.notNull(failureHandler, "failureHandler cannot be null");
        this.failureHandler = failureHandler;
    }

    public void setSwitchUserAuthorityChanger(SwitchUserAuthorityChanger switchUserAuthorityChanger) {
        this.switchUserAuthorityChanger = switchUserAuthorityChanger;
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = userDetailsChecker;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    private String stripUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int idx = uri.indexOf(59);
        if (idx > 0) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }
}

