/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.repo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.repo.DuracloudGroupRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudRightsRepo;
import org.duracloud.security.domain.SecurityUserBean;

public class UserFinderUtil {
    private DuracloudRepoMgr repoMgr;

    public UserFinderUtil(DuracloudRepoMgr repoMgr) {
        this.repoMgr = repoMgr;
    }

    public Set<DuracloudUser> getAccountUsers(AccountInfo account) {
        DuracloudRightsRepo rightsRepo = this.repoMgr.getRightsRepo();
        List<AccountRights> acctRights = rightsRepo.findByAccountId(account.getId());
        HashSet<DuracloudUser> users = new HashSet<DuracloudUser>();
        for (AccountRights rights : acctRights) {
            DuracloudUser user = rights.getUser();
            rights.getAccount();
            HashSet<AccountRights> accountOnlyRightsSet = new HashSet<AccountRights>();
            accountOnlyRightsSet.add(rights);
            user.setAccountRights(accountOnlyRightsSet);
            users.add(user);
        }
        List<DuracloudUser> rootUsers = this.repoMgr.getUserRepo().findByRootTrueAndEnabledTrueAndAccountNonExpiredTrueAndCredentialsNonExpiredTrueAndAccountNonLockedTrue();
        users.addAll(rootUsers);
        return users;
    }

    public Set<SecurityUserBean> convertDuracloudUsersToSecurityUserBeans(AccountInfo accountInfo, Set<DuracloudUser> users, boolean includeRootUsers) {
        Long accountId = accountInfo.getId();
        DuracloudGroupRepo groupRepo = this.repoMgr.getGroupRepo();
        HashSet<DuracloudGroup> groups = new HashSet<DuracloudGroup>();
        groups.addAll(groupRepo.findByAccountId(accountId));
        HashSet<SecurityUserBean> userBeans = new HashSet<SecurityUserBean>();
        for (DuracloudUser user : users) {
            String username = user.getUsername();
            String password = user.getPassword();
            String email = user.getEmail();
            String ipLimits = this.annotateAddressRange(accountInfo, user.getAllowableIPAddressRange());
            Set<Role> roles = user.getRolesByAcct(accountId);
            if (roles == null) {
                roles = new HashSet<Role>();
            }
            if (roles.isEmpty()) {
                roles.add(Role.ROLE_USER);
            }
            ArrayList<String> grants = new ArrayList<String>();
            for (Role role : roles) {
                grants.add(role.name());
            }
            if (user.isRoot() && !includeRootUsers) continue;
            SecurityUserBean bean = new SecurityUserBean(username, password, grants);
            bean.setEmail(email);
            bean.setIpLimits(ipLimits);
            if (groups != null) {
                for (DuracloudGroup group : groups) {
                    Set<DuracloudUser> grpUsers = group.getUsers();
                    if (!grpUsers.contains(user)) continue;
                    bean.addGroup(group.getName());
                }
            }
            userBeans.add(bean);
        }
        return userBeans;
    }

    private String annotateAddressRange(AccountInfo accountInfo, String baseRange) {
        if (null == baseRange || baseRange.equals("")) {
            return baseRange;
        }
        return baseRange;
    }
}

