/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jclouds.Fallback;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.PagedIterable;
import org.jclouds.collect.PagedIterables;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Throwables2;

public final class Fallbacks {
    private Fallbacks() {
    }

    public static <T> T valOnNotFoundOr404(T val, Throwable t) {
        if (Fallbacks.containsResourceNotFoundException(Preconditions.checkNotNull(t, "throwable")) || HttpUtils.contains404(t)) {
            return val;
        }
        throw Throwables.propagate(t);
    }

    private static boolean containsResourceNotFoundException(Throwable from) {
        return Throwables2.getFirstThrowableOfType(from, ResourceNotFoundException.class) != null;
    }

    public static final class EmptyMultimapOnNotFoundOr404
    implements Fallback<ImmutableMultimap<Object, Object>> {
        @Override
        public ListenableFuture<ImmutableMultimap<Object, Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public ImmutableMultimap<Object, Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableMultimap.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyMapOnNotFoundOr404
    implements Fallback<ImmutableMap<Object, Object>> {
        @Override
        public ListenableFuture<ImmutableMap<Object, Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public ImmutableMap<Object, Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableMap.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptySetOnNotFoundOr404
    implements Fallback<ImmutableSet<Object>> {
        @Override
        public ListenableFuture<ImmutableSet<Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public ImmutableSet<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableSet.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyListOnNotFoundOr404
    implements Fallback<ImmutableList<Object>> {
        @Override
        public ListenableFuture<ImmutableList<Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public ImmutableList<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(ImmutableList.of(), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyPagedIterableOnNotFoundOr404
    implements Fallback<PagedIterable<Object>> {
        @Override
        public ListenableFuture<PagedIterable<Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public PagedIterable<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(PagedIterables.of(IterableWithMarkers.from(ImmutableSet.of())), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyIterableWithMarkerOnNotFoundOr404
    implements Fallback<IterableWithMarker<Object>> {
        @Override
        public ListenableFuture<IterableWithMarker<Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public IterableWithMarker<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(IterableWithMarkers.from(ImmutableSet.of()), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class EmptyFluentIterableOnNotFoundOr404
    implements Fallback<FluentIterable<Object>> {
        @Override
        public ListenableFuture<FluentIterable<Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public FluentIterable<Object> createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(FluentIterable.from(ImmutableSet.of()), Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class AbsentOn403Or404Or500
    implements Fallback<Optional<Object>> {
        @Override
        public ListenableFuture<Optional<Object>> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public Optional<Object> createOrPropagate(Throwable t) throws Exception {
            Boolean returnVal = HttpUtils.returnValueOnCodeOrNull(Preconditions.checkNotNull(t, "throwable"), true, Predicates.in(Ints.asList(403, 404, 500)));
            if (returnVal != null) {
                return Optional.absent();
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class FalseOnNotFoundOr422
    implements Fallback<Boolean> {
        @Override
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Fallbacks.containsResourceNotFoundException(Preconditions.checkNotNull(t, "throwable")) || HttpUtils.returnValueOnCodeOrNull(t, true, Predicates.equalTo(422)) != null) {
                return false;
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class FalseOnNotFoundOr404
    implements Fallback<Boolean> {
        @Override
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(false, Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class TrueOnNotFoundOr404
    implements Fallback<Boolean> {
        @Override
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(true, Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class VoidOnNotFoundOr404
    implements Fallback<Void> {
        @Override
        public ListenableFuture<Void> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public Void createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(null, Preconditions.checkNotNull(t, "throwable"));
        }
    }

    public static final class NullOnNotFoundOr404
    implements Fallback<Object> {
        @Override
        public ListenableFuture<Object> create(Throwable t) throws Exception {
            return Futures.immediateFuture(this.createOrPropagate(t));
        }

        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            return Fallbacks.valOnNotFoundOr404(null, Preconditions.checkNotNull(t, "throwable"));
        }
    }
}

